/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.util.noticeImpl;

import cn.jpush.api.JPushClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.Notification;
import com.ptteng.common.util.notice.NoticeUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JiGuangNoticeUtilImpl
implements NoticeUtil {
    private static final Log LOG = LogFactory.getLog(JiGuangNoticeUtilImpl.class);
    private String appKey;
    private String masterSecret;

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getMasterSecret() {
        return this.masterSecret;
    }

    public void setMasterSecret(String masterSecret) {
        this.masterSecret = masterSecret;
    }

    @Override
    public void pushMessae(String channelId, String title, String message, Integer deviceType, Integer messageType, Integer msgExpires, String custom_content) {
    }

    @Override
    public String pushMessaeForList(String platform, String displayType, String type, String deviceTokens, String ticker, String title, String text, String afterOpen, String url, String activity, String custom, String extra, String out_biz_no, String production_mode, Long start_time, Long expire_time, String description) throws IOException {
        Object extras;
        JPushClient jpushClient = new JPushClient(this.masterSecret, this.appKey);
        PushPayload.Builder PayloadBuilder = PushPayload.newBuilder();
        PayloadBuilder.setPlatform(this.convertPlatform(platform));
        PayloadBuilder.setAudience(this.convertAudience(type, deviceTokens.split(",\\s*")));
        try {
            extras = JSONObject.fromObject((Object)extra);
        }
        catch (Exception e) {
            extras = Collections.emptyMap();
        }
        if ("notification".equals(displayType)) {
            PayloadBuilder.setNotification(this.convertNotification(platform, title, text, (Map<String, String>)extras));
        } else if ("message".equals(displayType)) {
            PayloadBuilder.setMessage(this.convertMessage(text, (Map<String, String>)extras));
        }
        PayloadBuilder.setOptions(this.getOptions(production_mode, expire_time));
        try {
            PushResult result = jpushClient.sendPush(PayloadBuilder.build());
            LOG.info((Object)("Got result - " + result));
            return "{\"ret\":\"SUCCESS\"}";
        }
        catch (APIConnectionException e) {
            LOG.error((Object)"Connection error, should retry later", (Throwable)e);
            return "{\"ret\":\"FAIL\",\"data\":{\"error_code\":\"FAIL\"}}";
        }
        catch (APIRequestException e) {
            LOG.error((Object)"Should review the error, and fix the request", (Throwable)e);
            LOG.info((Object)("HTTP Status: " + e.getStatus()));
            LOG.info((Object)("Error Code: " + e.getErrorCode()));
            LOG.info((Object)("Error Message: " + e.getErrorMessage()));
            return "{\"ret\":\"FAIL\",\"data\":{\"error_code\":" + e.getErrorCode() + "}}";
        }
    }

    private Options getOptions(String production_mode, Long expire_time) {
        Options.Builder builder = Options.newBuilder();
        builder.setApnsProduction(!"false".equals(production_mode));
        if (null != expire_time) {
            long current = System.currentTimeMillis();
            long expire = (expire_time - current) / 1000L;
            builder.setTimeToLive(expire);
        }
        return builder.build();
    }

    private Message convertMessage(String text, Map<String, String> extras) {
        return Message.newBuilder().setMsgContent(text).addExtras(extras).build();
    }

    private Audience convertAudience(String type, String ... deviceTokens) {
        if ("unicast".equals(type) ? deviceTokens.length == 1 : "listcast".equals(type)) {
            return Audience.alias((String[])deviceTokens);
        }
        throw new IllegalArgumentException();
    }

    private Notification convertNotification(String platform, String title, String text, Map<String, String> extra) {
        if ("ios".equals(platform)) {
            return Notification.ios((Object)text, extra);
        }
        if ("android".equals(platform)) {
            return Notification.android((String)text, (String)title, extra);
        }
        return Notification.alert((Object)text);
    }

    private Platform convertPlatform(String platform) {
        if ("ios".equals(platform)) {
            return Platform.ios();
        }
        if ("android".equals(platform)) {
            return Platform.android();
        }
        return null;
    }

    public static void main(String[] args) {
        JiGuangNoticeUtilImpl utilTest = new JiGuangNoticeUtilImpl();
        utilTest.setAppKey("e5678f0eb18d058b6ba062ae");
        utilTest.setMasterSecret("26fdcf155c2a9dfce885ad60");
        try {
            String result = utilTest.pushMessaeForList("ios", "notification", "listcast", "13012345678", "", "\u63a8\u9001\u6d4b\u8bd5-01-title", "\u63a8\u9001\u6d4b\u8bd5-01", "", "", "", "", "", "", "true", 0L, System.currentTimeMillis() + 604800000L, "");
            System.out.println("result = " + result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

