/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.dao;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.common.dao.util.SQLUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseDaoServiceImpl
implements BaseDaoService {
    protected Dao dao;
    private static final Log log = LogFactory.getLog(BaseDaoServiceImpl.class);

    public Dao getDao() {
        return this.dao;
    }

    public void setDao(Dao dao) {
        log.info((Object)("set dao " + dao));
        this.dao = dao;
    }

    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        String table = null;
        String sql = "";
        try {
            Table annotation = clz.getAnnotation(Table.class);
            Class<? extends Annotation> type = annotation.annotationType();
            Method method = type.getDeclaredMethod("name", null);
            table = (String)method.invoke((Object)annotation, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)(clz + "  run dynamic  wrong " + conditions + " start " + start + " size " + limit));
        }
        try {
            ArrayList<Long> ids;
            sql = SQLUtil.convert2Sql(conditions, start, limit);
            Object o = this.dao.excuteSimpleSql(sql, clz);
            if (o instanceof List) {
                log.info((Object)(String.valueOf(sql) + " result is list " + o));
                ids = new ArrayList<Long>();
                for (Object oo : (List)o) {
                    BigInteger id = (BigInteger)oo;
                    ids.add(id.longValue());
                }
                return ids;
            }
            log.info((Object)(String.valueOf(sql) + " result is not list " + o + " instance " + o.getClass()));
            ids = new ArrayList();
            BigInteger id = (BigInteger)o;
            ids.add(id.longValue());
            return ids;
        }
        catch (DaoException e) {
            log.error((Object)(" count by getPuserIds " + sql));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
    }

    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        try {
            this.dao.fakeDelete(clz, (Serializable)id);
        }
        catch (DaoException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(clz + " want delete " + ids));
        try {
            this.dao.deleteList(clz, ids);
        }
        catch (DaoException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws ServiceException, ServiceDaoException {
        BaseDaoServiceImpl s = new BaseDaoServiceImpl();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("p.type & like ", "\"%\u56e2\u8d2d%\"");
        params.put("p.name & like ", "\"%\u6052\u4fe1\u996e\u6599%\"");
        params.put(" p.update_by", "29");
        params.put(" p.status", "0");
        params.put("p.id", "pr.provider_id");
        params.put("@query", "p.id");
        params.put("@table", "provider p ,provider_publics_relation pr");
        params.put("@order", "p.update_at desc");
        params.put("p.id & in ", "3,5,6");
        params.put("@table", "provider p ,provider_publics_relation pr");
        String sql = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);
        log.info((Object)("sql is " + sql));
        HashMap<String, Object> params2 = new HashMap<String, Object>();
        params2.put("@update", "update");
        params2.put("@table", "statistics");
        params2.put("@field", "statistics_count");
        params2.put("@value", "statistics_count+1");
        params2.put("product_id", "1");
        String sql2 = SQLUtil.convert2Sql(params2, 0, Integer.MAX_VALUE);
        log.info((Object)(String.valueOf(sql2) + " is right ? "));
    }

    @Override
    public Object getObjectByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        String table = null;
        String sql = "";
        try {
            Table annotation = clz.getAnnotation(Table.class);
            Class<? extends Annotation> type = annotation.annotationType();
            Method method = type.getDeclaredMethod("name", null);
            table = (String)method.invoke((Object)annotation, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)(clz + "  run dynamic  wrong " + conditions + " start " + start + " size " + limit));
        }
        try {
            sql = SQLUtil.convert2Sql(conditions, start, limit);
            Object o = this.dao.excuteSimpleSql(sql, clz);
            log.info((Object)(String.valueOf(sql) + " result is not list " + o + " instance " + o.getClass()));
            return o;
        }
        catch (DaoException e) {
            log.error((Object)(" count by getPuserIds " + sql));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
    }
}

