/*
 * Decompiled with CFR 0.152.
 */
package com.qding.commnunity.common.weixin.service.impl;

import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.json.GsonUtil;
import com.qding.community.common.weixin.service.WeiXinSimpleService;
import com.qding.community.common.weixin.util.WeiXinPropertiesUtil;
import com.qding.community.common.weixin.vo.SubscribeMessage;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeiXinSimpleServiceImpl
implements WeiXinSimpleService {
    private static final Executor exec = Executors.newFixedThreadPool(3);
    private static final Log log = LogFactory.getLog(WeiXinSimpleServiceImpl.class);
    private static final String WATERMARK = "watermark";
    private static final String APPID = "appid";

    @Override
    public String sendSubscribeMessage(String accessToken, SubscribeMessage subscribeMessage, boolean asynchrony) {
        final String token = accessToken;
        final SubscribeMessage message = subscribeMessage;
        String result = "";
        if (asynchrony) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    String url = WeiXinPropertiesUtil.getProperty("subscribe_message");
                    url = url.replace("{accessToken}", token);
                    log.info((Object)("url is " + url));
                    String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)message.toString());
                    log.info((Object)("send result:" + httpsresponse));
                }
            };
            exec.execute(task);
        } else {
            String url = WeiXinPropertiesUtil.getProperty("subscribe_message");
            url = url.replace("{accessToken}", accessToken);
            log.info((Object)("subscribe message data is " + subscribeMessage.toString()));
            result = HttpClientUtil.sendPostRequestByJava((String)url, (String)subscribeMessage.toString());
        }
        return result;
    }

    @Override
    public String sendTemplateMessage(String accessToken, final String content, boolean asynchrony) {
        log.info((Object)(accessToken + " is accessToken and content is " + content));
        String result = "";
        final String token = accessToken;
        if (!asynchrony) {
            String url = WeiXinPropertiesUtil.getProperty("template");
            url = url.replace("{accessToken}", token);
            log.info((Object)("url is " + url));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
            log.info((Object)("generator:" + httpsresponse));
            return httpsresponse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                String url = WeiXinPropertiesUtil.getProperty("template");
                url = url.replace("{accessToken}", token);
                log.info((Object)("url is " + url));
                String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
                log.info((Object)("generator:" + httpsresponse));
            }
        };
        exec.execute(task);
        return result;
    }

    @Override
    public String uniformSendTemplateMessage(String accessToken, final String content, boolean asynchrony) {
        log.info((Object)(accessToken + " is accessToken and content is " + content));
        String result = "";
        final String token = accessToken;
        if (!asynchrony) {
            String url = WeiXinPropertiesUtil.getProperty("wxopentemplate");
            url = url.replace("{accessToken}", token);
            log.info((Object)("url is " + url));
            String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
            log.info((Object)("generator:" + httpsresponse));
            return httpsresponse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                String url = WeiXinPropertiesUtil.getProperty("wxopentemplate");
                url = url.replace("{accessToken}", token);
                log.info((Object)("url is " + url));
                String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)content);
                log.info((Object)("generator:" + httpsresponse));
            }
        };
        exec.execute(task);
        return result;
    }

    @Override
    public String getShortLink(String accessToken, String pageUrl, String pageTitle, boolean isPermanent) {
        String url = WeiXinPropertiesUtil.getProperty("genwxashortlink");
        url = url.replace("{accessToken}", accessToken);
        log.info((Object)("url is " + url));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("page_url", pageUrl);
        if (StringUtils.isNotEmpty((String)pageTitle)) {
            param.put("page_title", pageTitle);
        }
        String data = GsonUtil.toJson(param);
        param.put("is_permanent", isPermanent);
        String httpsresponse = HttpClientUtil.sendPostRequestByJava((String)url, (String)data);
        log.info((Object)("generator:" + httpsresponse));
        return httpsresponse;
    }

    @Override
    public String getUrlLink(String accessToken, String pageUrl, String pageTitle, boolean isPermanent) {
        return null;
    }

    @Override
    public String getUrlScheme(String accessToken, String pageUrl, String pageTitle, boolean isPermanent) {
        return null;
    }
}

