/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util.http.cookie;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestUtil {
    public static final String ENCODING = "UTF-8";
    private static transient Log log = LogFactory.getLog(RequestUtil.class);

    public static void setCacheHeader(HttpServletResponse response, int cacheAge) {
        response.setHeader("Pragma", "Public");
        response.setHeader("Cache-Control", "max-age=" + cacheAge);
        response.setDateHeader("Expires", System.currentTimeMillis() + (long)cacheAge * 1000L);
    }

    public static void setNoCacheHeader(HttpServletResponse response) {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    public static String dump(HttpServletRequest request) {
        String name;
        StringBuffer sb = new StringBuffer();
        Enumeration names = request.getAttributeNames();
        sb.append("\nrequest attributes: \n");
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            sb.append("name = [" + name + "] value = [" + request.getAttribute(name) + "]\n");
        }
        names = request.getParameterNames();
        sb.append("\nrequest parameter: \n");
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            sb.append("name = [" + name + "] value = [" + request.getParameter(name) + "]\n");
        }
        return sb.toString();
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String xReq = request.getHeader("X-Requested-With");
        return xReq != null;
    }

    public static String getRefer(HttpServletRequest request) {
        return request.getHeader("REFERER");
    }

    public static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getRequestCompleteURL(HttpServletRequest request) {
        return request.getRequestURL().append("?").append(request.getQueryString()).toString();
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int expiry, String domain, String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting cookie '" + name + " [ " + value + " ] ' on path '" + path + "'"));
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setSecure(false);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setPath(path != null ? path : "/");
        cookie.setMaxAge(expiry);
        response.addCookie(cookie);
    }

    public static void deleteCookie(HttpServletResponse response, String name, String domain, String path) {
        Cookie cookie = new Cookie(name, "");
        RequestUtil.deleteCookie(response, cookie, domain, path);
    }

    public static void deleteCookies(HttpServletResponse response, String[] names, String domain, String path) {
        if (null == names) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            Cookie cookie = new Cookie(names[i], "");
            RequestUtil.deleteCookie(response, cookie, domain, path);
        }
    }

    public static void deleteCookie(HttpServletResponse response, Cookie cookie, String domain, String path) {
        if (cookie != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting cookie '" + cookie.getName() + "' on domain '" + cookie.getDomain() + "' path '" + path + "'"));
            }
            cookie.setMaxAge(0);
            if (domain != null) {
                cookie.setDomain(domain);
            }
            cookie.setPath(path != null ? path : "/");
            response.addCookie(cookie);
        }
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        Cookie returnCookie = null;
        if (cookies == null) {
            return returnCookie;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie thisCookie = cookies[i];
            if (!thisCookie.getName().equals(name) || !StringUtils.isNotBlank((String)thisCookie.getValue())) continue;
            try {
                thisCookie.setValue(URLDecoder.decode(thisCookie.getValue(), "utf-8"));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            returnCookie = thisCookie;
            break;
        }
        return returnCookie;
    }

    public static String getClientIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String token = "101%7C60838320714eef171c4b26aa6877c625*s7aTZWrvBBVv-9EfQ6potZWFz8rZi3rDIqZcazop9tZV7-fHxszRUJcJsrvaCXTIvCDKKwTzAMw%3D";
        log.info((Object)token);
        token = URLDecoder.decode(token, "utf-8");
        log.info((Object)token);
        token = URLDecoder.decode(token, "utf-8");
        log.info((Object)token);
        token = URLEncoder.encode(token, "utf-8");
        log.info((Object)token);
    }
}

