/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlUtil {
    public static Document createDocument(String root) {
        try {
            return DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)root));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document parseStringToXml(String xml) {
        try {
            return DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document parseFileToXml(String filepath) {
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try {
            doc = saxReader.read(new File(filepath));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static Document parseFIOToXml(String filename) {
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try {
            InputStream in = XmlUtil.class.getResourceAsStream("xml/" + filename);
            doc = saxReader.read(in);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static Element getElementByXpath(String xpath, Document doc) {
        List parameterList = doc.selectNodes(xpath);
        if (parameterList != null && parameterList.size() > 0) {
            return (Element)parameterList.get(0);
        }
        return null;
    }

    public static Element getElementById(String id, Document doc) {
        return XmlUtil.getElementByXpath("//*[@id='" + id + "']", doc);
    }

    public static void insertElement(String name, String value, Document doc) {
        XmlUtil.insertElement(name, value, doc, false);
    }

    public static void insertElement(String name, String value, Document doc, boolean isCdata) {
        Element ele = DocumentHelper.createElement((String)name);
        if (isCdata) {
            CDATA cdata = DocumentHelper.createCDATA((String)value);
            ele.add(cdata);
        } else {
            ele.setText(value);
        }
        doc.getRootElement().add(ele);
    }

    public static Document insertElement(String pid, Element newele, Document doc) {
        return XmlUtil.insertElement(pid, newele, doc, 1);
    }

    public static Document insertElement(String pid, Element newele, Document doc, int i) {
        Element element = XmlUtil.getElementById(pid, doc);
        List list = element.getParent().content();
        list.add(list.indexOf(element) + i, newele);
        return doc;
    }

    public static boolean deleteNodes(Document doc, String xpath) {
        boolean flag = true;
        try {
            List nlist = doc.selectNodes(xpath);
            for (Node node : nlist) {
                node.detach();
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean deleteChildren(Element element) {
        boolean flag = true;
        try {
            List nlist = element.elements();
            for (Node node : nlist) {
                node.detach();
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean deleteElement(Element ele) {
        List list = ele.getParent().content();
        list.remove(list.indexOf(ele));
        return true;
    }

    public static String docToString(Document doc) {
        return doc.asXML();
    }

    public static boolean saveDocument(String filepath, Document document) {
        try {
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(new File(filepath)));
            writer.write(document);
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toXml(Class className, Object object) {
        String strXml = "";
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{className});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(object, (Writer)writer);
            strXml = writer.toString();
            writer.flush();
            strXml = strXml.replace("&lt;", "<");
            strXml = strXml.replace("&gt;", ">");
        }
        catch (Exception exception) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                }
                catch (Exception exception) {}
            }
        }
        return strXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toObject(Class className, String strXml) {
        Object object = null;
        StringReader reader = null;
        try {
            reader = new StringReader(strXml);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{className});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            object = unmarshaller.unmarshal((Reader)reader);
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
        return object;
    }
}

