/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static Log log = LogFactory.getLog(HttpClientUtil.class);

    private HttpClientUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream sendGetRequest(String reqURL, String decodeCharset, String param, HashMap<String, String> headers) {
        long responseLength = 0L;
        Object responseContent = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(reqURL + URLEncoder.encode(param));
        for (String key : headers.keySet()) {
            httpGet.setHeader(key, headers.get(key));
        }
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            log.info((Object)(" status = " + response.getStatusLine()));
            System.out.println(response);
            HttpEntity entity = response.getEntity();
            if (null != entity) {
                responseLength = entity.getContentLength();
                log.info((Object)(" responseLength = " + responseLength));
                InputStream instream = entity.getContent();
                log.info((Object)(" instream = " + instream));
                FileOutputStream fos = new FileOutputStream("d:/logo1.jpg");
                byte[] buffer = new byte[1024];
                int len1 = 0;
                while ((len1 = instream.read(buffer)) != -1) {
                    fos.write(buffer, 0, len1);
                }
                fos.close();
                InputStream inputStream = instream;
                return inputStream;
            }
        }
        catch (Exception e) {
            log.error((Object)"\u8be5\u5f02\u5e38\u901a\u5e38\u662f\u7f51\u7edc\u539f\u56e0\u5f15\u8d77\u7684,\u5982HTTP\u670d\u52a1\u5668\u672a\u542f\u52a8\u7b49,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object sendGetRequest(String reqURL, String decodeCharset, String param, HashMap<String, String> headers, boolean isFile, String filePath) {
        long responseLength = 0L;
        String responseContent = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(reqURL + URLEncoder.encode(param));
        for (String key : headers.keySet()) {
            httpGet.setHeader(key, headers.get(key));
        }
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            log.info((Object)(" status = " + response.getStatusLine()));
            System.out.println(response);
            HttpEntity entity = response.getEntity();
            if (null != entity) {
                responseLength = entity.getContentLength();
                log.info((Object)(" responseLength = " + responseLength));
                if (isFile) {
                    InputStream instream = entity.getContent();
                    log.info((Object)(" instream = " + instream));
                    FileOutputStream fos = new FileOutputStream(filePath);
                    byte[] buffer = new byte[1024];
                    int len1 = 0;
                    while ((len1 = instream.read(buffer)) != -1) {
                        fos.write(buffer, 0, len1);
                    }
                    fos.close();
                    InputStream inputStream = instream;
                    return inputStream;
                }
                String string = responseContent = EntityUtils.toString((HttpEntity)entity, (String)(decodeCharset == null ? "UTF-8" : decodeCharset));
                return string;
            }
        }
        catch (Exception e) {
            log.error((Object)"\u8be5\u5f02\u5e38\u901a\u5e38\u662f\u7f51\u7edc\u539f\u56e0\u5f15\u8d77\u7684,\u5982HTTP\u670d\u52a1\u5668\u672a\u542f\u52a8\u7b49,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGetRequest(String reqURL, String decodeCharset) {
        long responseLength = 0L;
        String responseContent = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(reqURL);
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            System.out.println(response);
            HttpEntity entity = response.getEntity();
            if (null != entity) {
                responseLength = entity.getContentLength();
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)(decodeCharset == null ? "UTF-8" : decodeCharset));
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u8be5\u5f02\u5e38\u901a\u5e38\u662f\u7f51\u7edc\u539f\u56e0\u5f15\u8d77\u7684,\u5982HTTP\u670d\u52a1\u5668\u672a\u542f\u52a8\u7b49,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return responseContent;
    }

    public static String httpPost(String url, Map<String, String> params, String encoding) throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        System.out.println("url:" + url);
        HttpPost post = new HttpPost(url);
        ArrayList<BasicNameValuePair> postData = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            postData.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            System.out.println(entry.getValue());
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(postData, encoding);
        post.setEntity((HttpEntity)entity);
        HttpResponse response = httpClient.execute((HttpUriRequest)post);
        return HttpClientUtil.getContent(response, encoding);
    }

    public static String getContent(HttpResponse res, String encoding) throws Exception {
        HttpEntity ent = res.getEntity();
        String result = IOUtils.toString((InputStream)ent.getContent(), (String)encoding);
        ent.consumeContent();
        return result;
    }

    public static String sendPostRequest(String reqURL, String sendData, boolean isEncoder) {
        return HttpClientUtil.sendPostRequest(reqURL, sendData, isEncoder, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequest(String reqURL, String sendData, boolean isEncoder, String encodeCharset, String decodeCharset) {
        String responseContent = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost(reqURL);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            if (isEncoder) {
                ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                for (String str : sendData.split("&")) {
                    formParams.add(new BasicNameValuePair(str.substring(0, str.indexOf("=")), str.substring(str.indexOf("=") + 1)));
                }
                httpPost.setEntity((HttpEntity)new StringEntity(URLEncodedUtils.format(formParams, (String)(encodeCharset == null ? "UTF-8" : encodeCharset))));
            } else {
                httpPost.setEntity((HttpEntity)new StringEntity(sendData));
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (null != entity) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)(decodeCharset == null ? "UTF-8" : decodeCharset));
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u4e0e[" + reqURL + "]\u901a\u4fe1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b"), (Throwable)e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequest(String reqURL, Map<String, String> params, String encodeCharset, String decodeCharset) {
        String responseContent = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost(reqURL);
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, encodeCharset == null ? "UTF-8" : encodeCharset));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (null != entity) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)(decodeCharset == null ? "UTF-8" : decodeCharset));
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u4e0e[" + reqURL + "]\u901a\u4fe1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b"), (Throwable)e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return responseContent;
    }

    public static String sendPostSSLRequest(String reqURL, Map<String, String> params) {
        return HttpClientUtil.sendPostSSLRequest(reqURL, params, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostSSLRequest(String reqURL, Map<String, String> params, String encodeCharset, String decodeCharset) {
        String responseContent = "";
        DefaultHttpClient httpClient = new DefaultHttpClient();
        X509TrustManager xtm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            HttpResponse response;
            HttpEntity entity;
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{xtm}, null);
            SSLSocketFactory socketFactory = new SSLSocketFactory(ctx);
            httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
            HttpPost httpPost = new HttpPost(reqURL);
            if (null != params) {
                ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, encodeCharset == null ? "UTF-8" : encodeCharset));
            }
            if (null != (entity = (response = httpClient.execute((HttpUriRequest)httpPost)).getEntity())) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)(decodeCharset == null ? "UTF-8" : decodeCharset));
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u4e0e[" + reqURL + "]\u901a\u4fe1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u4e3a"), (Throwable)e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return responseContent;
    }

    public static String sendPostRequestByJava(String reqURL, Map<String, String> params) {
        StringBuilder sendData = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sendData.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        if (sendData.length() > 0 && sendData.toString().endsWith("&")) {
            sendData.setLength(sendData.length() - 1);
        }
        return HttpClientUtil.sendPostRequestByJava(reqURL, sendData.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequestByJava(String reqURL, String sendData) {
        HttpURLConnection httpURLConnection = null;
        OutputStream out = null;
        InputStream in = null;
        int httpStatusCode = 0;
        try {
            URL sendUrl = new URL(reqURL);
            httpURLConnection = (HttpURLConnection)sendUrl.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setConnectTimeout(30000);
            httpURLConnection.setReadTimeout(30000);
            out = httpURLConnection.getOutputStream();
            out.write(sendData.toString().getBytes("UTF-8"));
            out.flush();
            httpStatusCode = httpURLConnection.getResponseCode();
            in = httpURLConnection.getInputStream();
            byte[] byteDatas = new byte[in.available()];
            in.read(byteDatas);
            String string = new String(byteDatas);
            return string;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            String string = "Failed`" + httpStatusCode;
            return string;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u51fa\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                httpURLConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPutRequestByJava(String reqURL, String sendData) {
        HttpURLConnection httpURLConnection = null;
        OutputStream out = null;
        InputStream in = null;
        int httpStatusCode = 0;
        try {
            URL sendUrl = new URL(reqURL);
            httpURLConnection = (HttpURLConnection)sendUrl.openConnection();
            httpURLConnection.setRequestMethod("PUT");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setConnectTimeout(30000);
            httpURLConnection.setReadTimeout(30000);
            out = httpURLConnection.getOutputStream();
            out.write(sendData.toString().getBytes("UTF-8"));
            out.flush();
            httpStatusCode = httpURLConnection.getResponseCode();
            in = httpURLConnection.getInputStream();
            byte[] byteDatas = new byte[in.available()];
            in.read(byteDatas);
            String string = new String(byteDatas);
            return string;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            String string = "Failed`" + httpStatusCode;
            return string;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u51fa\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                httpURLConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendDeleteRequestByJava(String reqURL) {
        HttpURLConnection httpURLConnection = null;
        OutputStream out = null;
        InputStream in = null;
        int httpStatusCode = 0;
        try {
            URL sendUrl = new URL(reqURL);
            httpURLConnection = (HttpURLConnection)sendUrl.openConnection();
            httpURLConnection.setRequestMethod("DELETE");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setConnectTimeout(30000);
            httpURLConnection.setReadTimeout(30000);
            httpStatusCode = httpURLConnection.getResponseCode();
            in = httpURLConnection.getInputStream();
            byte[] byteDatas = new byte[in.available()];
            in.read(byteDatas);
            String string = new String(byteDatas);
            return string;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            String string = "Failed`" + httpStatusCode;
            return string;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u51fa\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                httpURLConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGetSqSLRequest(String reqURL, String encodeCharset, String decodeCharset) {
        String responseContent = "";
        DefaultHttpClient httpClient = new DefaultHttpClient();
        X509TrustManager xtm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{xtm}, null);
            SSLSocketFactory socketFactory = new SSLSocketFactory(ctx);
            httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
            HttpGet httpGet = new HttpGet(reqURL);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (null != entity) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)(decodeCharset == null ? "UTF-8" : decodeCharset));
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u4e0e[" + reqURL + "]\u901a\u4fe1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u4e3a"), (Throwable)e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequestByJavaSetHeader(String reqURL, String sendData, String contentType, String authorization) {
        HttpURLConnection httpURLConnection = null;
        OutputStream out = null;
        InputStream in = null;
        int httpStatusCode = 0;
        try {
            URL sendUrl = new URL(reqURL);
            httpURLConnection = (HttpURLConnection)sendUrl.openConnection();
            httpURLConnection.setRequestProperty("Authorization", authorization);
            httpURLConnection.setRequestProperty("Content-Type", contentType);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setConnectTimeout(30000);
            httpURLConnection.setReadTimeout(30000);
            out = httpURLConnection.getOutputStream();
            out.write(sendData.toString().getBytes("UTF-8"));
            out.flush();
            httpStatusCode = httpURLConnection.getResponseCode();
            in = httpURLConnection.getInputStream();
            byte[] byteDatas = new byte[in.available()];
            in.read(byteDatas);
            String string = new String(byteDatas);
            return string;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            String string = "Failed`" + httpStatusCode;
            return string;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u51fa\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                httpURLConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequestByJavaByteSetHeader(String reqURL, String sendData, String contentType, String authorization) {
        HttpURLConnection httpURLConnection = null;
        OutputStream out = null;
        InputStream in = null;
        Object inr = null;
        int httpStatusCode = 0;
        try {
            URL sendUrl = new URL(reqURL);
            httpURLConnection = (HttpURLConnection)sendUrl.openConnection();
            httpURLConnection.setRequestProperty("Authorization", authorization);
            httpURLConnection.setRequestProperty("Content-Type", contentType);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setConnectTimeout(30000);
            httpURLConnection.setReadTimeout(30000);
            out = httpURLConnection.getOutputStream();
            out.write(sendData.toString().getBytes("UTF-8"));
            out.flush();
            httpStatusCode = httpURLConnection.getResponseCode();
            in = httpURLConnection.getInputStream();
            byte[] b = new byte[1024000];
            int len = 0;
            int temp = 0;
            while ((temp = in.read()) != -1) {
                b[len] = (byte)temp;
                ++len;
            }
            String string = new String(b, 0, len, "UTF-8");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            String string = "Failed`" + httpStatusCode;
            return string;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u51fa\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\u5982\u4e0b", (Throwable)e);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                httpURLConnection = null;
            }
        }
    }

    public static String httpPostData(String host, String uri, String authorization, String data) {
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost("http://" + host + uri);
            httppost.addHeader("Host", host);
            httppost.addHeader("Authorization", authorization);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("data", data));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String rev = EntityUtils.toString((HttpEntity)response.getEntity());
                return rev;
            }
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "exception";
    }

    public static String httpPostBody(String uri, Map<String, String> headers, Map<String, String> body) {
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(uri);
            Set<String> headerKeySet = headers.keySet();
            if (headerKeySet.size() > 0) {
                for (String key : headerKeySet) {
                    log.info((Object)(" key = " + key + " value = " + headers.get(key)));
                    httppost.addHeader(key, headers.get(key));
                }
            }
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            Set<String> bodyKeySet = body.keySet();
            if (bodyKeySet.size() > 0) {
                for (String key : bodyKeySet) {
                    log.info((Object)(" key = " + key + " value = " + body.get(key)));
                    params.add(new BasicNameValuePair(key, body.get(key)));
                }
            }
            String ss = "{\"grant_type\": \"client_credentials\",\"client_id\": \"YXA6-Fq6QGgbEeaQT1FYxElvEw\",\"client_secret\": \"YXA6cas8UUM46_eX9-wuJ3TdJdGgVVY\"}";
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                String rev = EntityUtils.toString((HttpEntity)response.getEntity());
                return rev;
            }
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "exception";
    }

    public static String postFile(File file, String url, String partName) {
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost filePost = new HttpPost(url);
            MultipartEntity reqEntity = new MultipartEntity();
            FileBody fileBody = new FileBody(file);
            reqEntity.addPart(partName, (ContentBody)fileBody);
            filePost.setEntity((HttpEntity)reqEntity);
            HttpResponse response = httpclient.execute((HttpUriRequest)filePost);
            int code = response.getStatusLine().getStatusCode();
            String rev = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info((Object)(code + " resulit is  " + rev));
            return rev;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        HashMap headers = new HashMap();
        HashMap bodies = new HashMap();
        String ss = "{\"grant_type\": \"client_credentials\",\"client_id\": \"YXA6-Fq6QGgbEeaQT1FYxElvEw\",\"client_secret\": \"YXA6cas8UUM46_eX9-wuJ3TdJdGgVVY\"}";
        String requestParam = "<xml><bill_date><![CDATA[20170314]]></bill_date><bill_type><![CDATA[ALL]]></bill_type><mch_id><![CDATA[105500000209]]></mch_id><nonce_str><![CDATA[GcWMfOfqxztoDknRhWKSfCtLclgHdPCi]]></nonce_str><service><![CDATA[pay.bill.agent]]></service><sign><![CDATA[81666B1E5C125A6CEBF70B2884E59CF0]]></sign></xml>";
        String url = "https://download.swiftpass.cn/gateway";
        String result = HttpClientUtil.sendPostRequestByJavaByteSetHeader(url, requestParam, "application/xml", "");
    }
}

