/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

public class LogisticsUtil {
    private static String EBusinessID = "1256381";
    private static String AppKey = "9bf88769-2c57-44e3-93a7-54b3a623b639";
    private static String ReqURL = "http://api.kdniao.cc/Ebusiness/EbusinessOrderHandle.aspx";
    private static String defaultPropertyFile = "unicode_to_logistics.txt";
    public static Map<String, String> logisticsMap = new HashMap<String, String>();

    public static String getOrderTracesByJson(String ShipperCode, String LogisticCode) throws Exception {
        String requestData = "{'OrderCode':'','ShipperCode':'" + ShipperCode + "','LogisticCode':'" + LogisticCode + "'}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("RequestData", LogisticsUtil.urlEncoder(requestData, "UTF-8"));
        params.put("EBusinessID", EBusinessID);
        params.put("RequestType", "1002");
        String dataSign = LogisticsUtil.encrypt(requestData, AppKey, "UTF-8");
        params.put("DataSign", LogisticsUtil.urlEncoder(dataSign, "UTF-8"));
        params.put("DataType", "2");
        String result = LogisticsUtil.sendPost(ReqURL, params);
        return result;
    }

    public static String getOrderTracesByXml() throws Exception {
        String requestData = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><Content><OrderCode></OrderCode><ShipperCode>SF</ShipperCode><LogisticCode>589707398027</LogisticCode></Content>";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("RequestData", LogisticsUtil.urlEncoder(requestData, "UTF-8"));
        params.put("EBusinessID", EBusinessID);
        params.put("RequestType", "1002");
        String dataSign = LogisticsUtil.encrypt(requestData, AppKey, "UTF-8");
        params.put("DataSign", LogisticsUtil.urlEncoder(dataSign, "UTF-8"));
        params.put("DataType", "1");
        String result = LogisticsUtil.sendPost(ReqURL, params);
        return result;
    }

    private static String MD5(String str, String charset) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(str.getBytes(charset));
        byte[] result = md.digest();
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < result.length; ++i) {
            int val = result[i] & 0xFF;
            if (val <= 15) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString().toLowerCase();
    }

    private static String base64(String str, String charset) throws UnsupportedEncodingException {
        String encoded = Base64.encode(str.getBytes(charset));
        return encoded;
    }

    private static String urlEncoder(String str, String charset) throws UnsupportedEncodingException {
        String result = URLEncoder.encode(str, charset);
        return result;
    }

    private static String encrypt(String content, String keyValue, String charset) throws UnsupportedEncodingException, Exception {
        if (keyValue != null) {
            return LogisticsUtil.base64(LogisticsUtil.MD5(content + keyValue, charset), charset);
        }
        return LogisticsUtil.base64(LogisticsUtil.MD5(content, charset), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendPost(String url, Map<String, String> params) {
        OutputStreamWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.connect();
            out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            if (params != null) {
                StringBuilder param = new StringBuilder();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (param.length() > 0) {
                        param.append("&");
                    }
                    param.append(entry.getKey());
                    param.append("=");
                    param.append(entry.getValue());
                    System.out.println(entry.getKey() + ":" + entry.getValue());
                }
                System.out.println("param:" + param.toString());
                out.write(param.toString());
            }
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result.toString();
    }

    public static void main(String[] args) {
        try {
            String result = LogisticsUtil.getOrderTracesByJson("122", "1000642643774");
            System.out.println(result);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    static {
        String fileName = LogisticsUtil.class.getClassLoader().getResource(defaultPropertyFile).getFile();
        File file = new File(fileName);
        int count = 0;
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufReader = new BufferedReader(fileReader);
            String line = null;
            while ((line = bufReader.readLine()) != null) {
                System.out.println(line);
                String[] lines = line.split(" ");
                String value = lines[1];
                logisticsMap.put(lines[0], value);
                System.out.println(lines[0] + " " + value);
                ++count;
            }
            bufReader.close();
            fileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(count);
    }
}

