/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlUtil {
    private static final String PREFIX_XML = "<xml>";
    private static final String SUFFIX_XML = "</xml>";
    private static final String PREFIX_CDATA = "<![CDATA[";
    private static final String SUFFIX_CDATA = "]]>";

    public static Document createDocument(String root) {
        try {
            return DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)root));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document parseStringToXml(String xml) {
        try {
            return DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document parseFileToXml(String filepath) {
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try {
            doc = saxReader.read(new File(filepath));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static Document parseFIOToXml(String filename) {
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try {
            InputStream in = XmlUtil.class.getResourceAsStream("xml/" + filename);
            doc = saxReader.read(in);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static Element getElementByXpath(String xpath, Document doc) {
        List parameterList = doc.selectNodes(xpath);
        if (parameterList != null && parameterList.size() > 0) {
            return (Element)parameterList.get(0);
        }
        return null;
    }

    public static Element getElementById(String id, Document doc) {
        return XmlUtil.getElementByXpath("//*[@id='" + id + "']", doc);
    }

    public static void insertElement(String name, String value, Document doc) {
        XmlUtil.insertElement(name, value, doc, false);
    }

    public static void insertElement(String name, String value, Document doc, boolean isCdata) {
        Element ele = DocumentHelper.createElement((String)name);
        if (isCdata) {
            CDATA cdata = DocumentHelper.createCDATA((String)value);
            ele.add(cdata);
        } else {
            ele.setText(value);
        }
        doc.getRootElement().add(ele);
    }

    public static Document insertElement(String pid, Element newele, Document doc) {
        return XmlUtil.insertElement(pid, newele, doc, 1);
    }

    public static Document insertElement(String pid, Element newele, Document doc, int i) {
        Element element = XmlUtil.getElementById(pid, doc);
        List list = element.getParent().content();
        list.add(list.indexOf(element) + i, newele);
        return doc;
    }

    public static boolean deleteNodes(Document doc, String xpath) {
        boolean flag = true;
        try {
            List nlist = doc.selectNodes(xpath);
            for (Node node : nlist) {
                node.detach();
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean deleteChildren(Element element) {
        boolean flag = true;
        try {
            List nlist = element.elements();
            for (Node node : nlist) {
                node.detach();
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean deleteElement(Element ele) {
        List list = ele.getParent().content();
        list.remove(list.indexOf(ele));
        return true;
    }

    public static String docToString(Document doc) {
        return doc.asXML();
    }

    public static boolean saveDocument(String filepath, Document document) {
        try {
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(new File(filepath)));
            writer.write(document);
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toXml(Class className, Object object) {
        String strXml = "";
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{className});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(object, (Writer)writer);
            strXml = writer.toString();
            writer.flush();
            strXml = strXml.replace("&lt;", "<");
            strXml = strXml.replace("&gt;", ">");
        }
        catch (Exception exception) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                }
                catch (Exception exception) {}
            }
        }
        return strXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toObject(Class className, String strXml) {
        Object object = null;
        StringReader reader = null;
        try {
            reader = new StringReader(strXml);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{className});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            object = unmarshaller.unmarshal((Reader)reader);
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
        return object;
    }

    public static Map<String, Object> dom2Map(Document doc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (doc == null) {
            return map;
        }
        Element root = doc.getRootElement();
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            List list = e.elements();
            if (list.size() > 0) {
                map.put(e.getName(), XmlUtil.dom2Map(e));
                continue;
            }
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static Map dom2Map(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Map> mapList = new ArrayList<Object>();
                if (iter.elements().size() > 0) {
                    Map m = XmlUtil.dom2Map(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = new ArrayList();
                            mapList.add((Map)obj);
                            mapList.add(m);
                        }
                        if (obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!obj.getClass().getName().equals("java.util.ArrayList")) {
                        mapList = new ArrayList();
                        mapList.add((Map)obj);
                        mapList.add((Map)((Object)iter.getText()));
                    }
                    if (obj.getClass().getName().equals("java.util.ArrayList")) {
                        mapList = (List)obj;
                        mapList.add((Map)((Object)iter.getText()));
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static String xmlFormat(Map<String, String> parm, boolean isAddCDATA) {
        StringBuffer strbuff = new StringBuffer(PREFIX_XML);
        if (MapUtils.isNotEmpty(parm)) {
            for (Map.Entry<String, String> entry : parm.entrySet()) {
                strbuff.append("<").append(entry.getKey()).append(">");
                if (isAddCDATA) {
                    strbuff.append(PREFIX_CDATA);
                    if (StringUtils.isNotEmpty((String)entry.getValue())) {
                        strbuff.append(entry.getValue());
                    }
                    strbuff.append(SUFFIX_CDATA);
                } else if (StringUtils.isNotEmpty((String)entry.getValue())) {
                    strbuff.append(entry.getValue());
                }
                strbuff.append("</").append(entry.getKey()).append(">");
            }
        }
        String str = strbuff.append(SUFFIX_XML).toString();
        System.out.println("str=" + str);
        return str;
    }

    public static Map<String, String> xmlParse(String xml) throws XmlPullParserException, IOException {
        HashMap<String, String> map = null;
        if (StringUtils.isNotEmpty((String)xml)) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
            XmlPullParser pullParser = XmlPullParserFactory.newInstance().newPullParser();
            pullParser.setInput((InputStream)inputStream, "UTF-8");
            int eventType = pullParser.getEventType();
            System.out.println("eventType=" + eventType);
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        map = new HashMap<String, String>();
                        break;
                    }
                    case 2: {
                        String key = pullParser.getName();
                        if (key.equals("xml")) break;
                        String value = pullParser.nextText().trim();
                        map.put(key, value);
                        break;
                    }
                }
                eventType = pullParser.next();
            }
        }
        return map;
    }
}

