/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;

public class ExportUtil {
    private static final SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String title, List<String> headers, List<List<Object>> dataset, OutputStream out) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(15);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor((short)40);
        style.setFillPattern((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderTop((short)1);
        style.setAlignment((short)2);
        HSSFFont font = workbook.createFont();
        font.setColor((short)20);
        font.setFontHeightInPoints((short)12);
        font.setBoldweight((short)700);
        style.setFont(font);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFComment comment = patriarch.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)new HSSFRichTextString("\u53ef\u4ee5\u5728POI\u4e2d\u6dfb\u52a0\u6ce8\u91ca\uff01"));
        comment.setAuthor("948");
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headers.size(); ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(style);
            HSSFRichTextString hSSFRichTextString = new HSSFRichTextString(headers.get(i));
            cell.setCellValue((RichTextString)hSSFRichTextString);
        }
        int index = 1;
        for (List list : dataset) {
            row = sheet.createRow(index++);
            for (int i = 0; i < list.size(); ++i) {
                HSSFCell cell = row.createCell(i);
                try {
                    Object value = list.get(i);
                    HSSFRichTextString textValue = null;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                        continue;
                    }
                    if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        textValue = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)textValue);
                        continue;
                    }
                    if (value instanceof Double) {
                        double dValue = (Double)value;
                        textValue = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)textValue);
                        continue;
                    }
                    if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                        continue;
                    }
                    if (value instanceof Date) {
                        cell.setCellValue(datetimeFormat.format((Date)value));
                        continue;
                    }
                    if (value instanceof String) {
                        cell.setCellValue((String)value);
                        continue;
                    }
                    if (!(value instanceof Character)) continue;
                    cell.setCellValue(value + "");
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

