/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataUtils {
    public static boolean isChinese(String str) {
        boolean result = false;
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            if (chr1 < '\u4e00' || chr1 > '\u29fa5') continue;
            result = true;
        }
        return result;
    }

    public static String chinaToUnicode(String str) {
        String result = "";
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            result = chr1 >= '\u4e00' && chr1 <= '\u29fa5' ? result + "\\u" + Integer.toHexString(chr1) : result + str.charAt(i);
        }
        return result;
    }

    public static boolean isNullOrEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        return "".equals(obj);
    }

    public static boolean isNotNullOrEmpty(Object obj) {
        return !DataUtils.isNullOrEmpty(obj);
    }

    public static String getUniqueName(String filename) {
        return DataUtils.getUUID() + filename.substring(filename.lastIndexOf("."));
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getSimpleUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String hash(String data) {
        return data.hashCode() + "";
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String changeUrl(String url, String[] param) {
        if (param != null) {
            for (int i = 0; i < param.length; ++i) {
                url = url.replace("{" + (i + 1) + "}", param[i]);
            }
        }
        return url;
    }

    public static String md5(String str) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return str;
        }
        md.update(str.getBytes());
        byte[] bs = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bs.length; ++i) {
            int v = bs[i] & 0xFF;
            if (v < 16) {
                sb.append(0);
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString();
    }

    public static String getSuffix(String filename) {
        String suffix = "";
        int pos = filename.lastIndexOf(46);
        if (pos > 0 && pos < filename.length() - 1) {
            suffix = filename.substring(pos + 1);
        }
        return suffix;
    }

    public static String getRandomString(int length) {
        String seed = "ABCDEFGHJKMNPQRSTUVWXYY23456789";
        int subIndex = 0;
        String retString = "";
        for (int i = 0; i < length; ++i) {
            subIndex = (int)(Math.random() * 100.0 % (double)seed.length());
            retString = retString + seed.substring(subIndex, subIndex + 1);
        }
        return retString;
    }

    public static String getRandomIntString(int length) {
        String seed = "0123456789";
        int subIndex = 0;
        String retString = "";
        for (int i = 0; i < length; ++i) {
            subIndex = (int)(Math.random() * 100.0 % (double)seed.length());
            retString = retString + seed.substring(subIndex, subIndex + 1);
        }
        return retString;
    }

    public static String search(String s1, String s2) {
        String max = "";
        for (int i = 0; i < s1.length(); ++i) {
            for (int j = i; j <= s1.length(); ++j) {
                String sub = s1.substring(i, j);
                if (s2.indexOf(sub) == -1 || sub.length() <= max.length()) continue;
                max = sub;
            }
        }
        return max;
    }

    public static boolean checkTelephone(String tel) {
        String regExp = "^((13[0-9])|(15[0-9])|(18[0-9]))\\d{8}$";
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(tel.trim());
        return m.find();
    }

    public static String getFixLenthString(int strLength) {
        Random rm = new Random();
        double pross = (1.0 + rm.nextDouble()) * Math.pow(10.0, strLength);
        String fixLenthString = String.valueOf(pross);
        return fixLenthString.substring(1, strLength + 1);
    }

    public static String priceTofen(String price) {
        BigDecimal bd = new BigDecimal(price);
        BigDecimal bd2 = new BigDecimal(100);
        BigInteger re = bd.multiply(bd2).toBigInteger();
        return re.toString();
    }

    public static String priceToString(String price) {
        int idx = price.indexOf(".");
        if (idx == -1) {
            return price + ".00";
        }
        int pos = price.substring(idx + 1).length();
        if (pos == 1) {
            return price + "0";
        }
        if (pos > 2) {
            return price.substring(0, idx + 3);
        }
        return price;
    }
}

