package com.qding.common.util;

import java.io.*;
import java.util.*;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.util.StringUtil;
import org.dom4j.*;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;


/**
 * Created by Administrator on 14-6-24.
 */
public class XmlUtil {
    private static final String PREFIX_XML = "<xml>";

    private static final String SUFFIX_XML = "</xml>";

    private static final String PREFIX_CDATA = "<![CDATA[";

    private static final String SUFFIX_CDATA = "]]>";
    /**
     * 创建docment
     * @param root
     * @return
     */
    public static Document createDocument(String root)
    {
        try {
            return DocumentHelper.createDocument(DocumentHelper.createElement(root));
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 将xml类型的字符串转换成document对象进行操作
     * @param xml
     * @return
     */
    public static Document parseStringToXml(String xml)
    {
        try {
            return DocumentHelper.parseText(xml);
        } catch (DocumentException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 读取xml文件
     * @param filepath
     * @return
     */
    public static Document parseFileToXml(String filepath)
    {
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try {
            doc = saxReader.read(new File(filepath));
        } catch (DocumentException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return doc;
    }

    /**
     * 获取webapp 相对路径下的xml文件
     * @param filename
     * @return
     */
    public static Document parseFIOToXml(String filename)
    {
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try {
            InputStream in = XmlUtil.class.getResourceAsStream("xml/"+filename);
            doc = saxReader.read(in);
        } catch (DocumentException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return doc;
    }


    /**
     * 根据xpath 获取指定的元素
     * @param xpath
     * @param doc
     * @return
     */
    public static Element getElementByXpath(String xpath,Document doc)
    {
        List<Element> parameterList = doc.selectNodes(xpath);
        if(parameterList!=null && parameterList.size()>0)
        {
            return (Element)parameterList.get(0);
        }
        return null;
    }

    /**
     * 获取指定id的xml元素(单个xml中id唯一的情况下使用)
     * @param id
     * @param doc
     * @return
     */
    public static Element getElementById(String id,Document doc)
    {
        return getElementByXpath("//*[@id='"+id+"']",doc);
    }

    /**
     * 插入元素
     * @param name
     * @param value
     * @param doc
     * @return
     */
    public static void insertElement(String name,String value,Document doc)
    {
        insertElement(name,value,doc,false);
    }

    /**
     * 插入元素
     * @param name
     * @param value
     * @param doc
     * @return
     */
    public static void insertElement(String name,String value,Document doc,boolean isCdata)
    {
        Element ele = DocumentHelper.createElement(name);
        if(isCdata){
            CDATA cdata = DocumentHelper.createCDATA(value);
            ele.add(cdata);
        }else{
            ele.setText(value);
        }
        doc.getRootElement().add(ele);
    }

    /**
     * 在指定id的元素后面插入元素
     * @param pid
     * @param newele
     * @param doc
     * @return
     */
    public static Document insertElement(String pid,Element newele,Document doc)
    {
        return insertElement(pid, newele, doc,1);
    }

    /**
     * 在指定id的元素后面或前面插入元素
     * @param pid
     * @param newele
     * @param doc
     * @param i 为1表示在坐标元素之后----- 为0 则在坐标元素之前
     * @return
     */
    public static Document insertElement(String pid,Element newele,Document doc,int i)
    {
        Element element = getElementById(pid, doc);//坐标元素

        List<Element> list = element.getParent().content();//获取坐标元素父元素下的所有元素

        // list.indexOf(valueEle)+1, +1 表示在坐标元素之后； 不+1，则在坐标元素之前
        list.add(list.indexOf(element)+i, newele);

        return doc;
    }


    /**
     * 删除文档doc的指定路径下的所有子节点（包含元素，属性等）
     * <br/> 如果路径相同一并删除
     * @param doc     文档对象
     * @param xpath 指定元素的路径    根据路径可删除元素、属性
     * @return 删除成功时返回true，否则false
     */
    public static boolean deleteNodes(Document doc, String xpath) {
        boolean flag = true;
        try {
            List<Node> nlist = doc.selectNodes(xpath);
            for (Node node : nlist) {
                node.detach();
            }
        } catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    /**
     * 删除一个父元素下所有的子节点（包含元素，属性等）
     *
     * @param element 父元素
     * @return 删除成功时返回true，否则false
     */
    public static boolean deleteChildren(Element element) {
        boolean flag = true;
        try {
            List<Node> nlist = element.elements();
            for (Node node : nlist) {
                node.detach();
            }
        } catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    /**
     * 删除指定的元素
     * @param ele
     * @return
     */
    public static boolean deleteElement(Element ele)
    {
        List<Element> list = ele.getParent().content();
        list.remove(list.indexOf(ele));
        return true;
    }

    /**
     * 将doc转为字符串
     * @param doc
     * @return
     */
    public static String docToString(Document doc)
    {
        return doc.asXML();
    }

    /**
     * 保存xml
     * @param filepath
     * @param document
     * @return 操作标识符
     */
    public static boolean saveDocument(String filepath,Document document)
    {
        try {
            XMLWriter writer = new XMLWriter(new FileWriter(new File(filepath)));
            writer.write(document);
            writer.close();
            return true;
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 对象转XML
     * @param className
     * @param object
     * @return
     */
    public static String toXml(Class className, Object object) {
        String strXml = "";
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance(className);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT,true);
            marshaller.marshal(object, writer);
            strXml = writer.toString();
            writer.flush();

            strXml = strXml.replace("&lt;","<");
            strXml = strXml.replace("&gt;",">");
        } catch (Exception e) {
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                } catch (Exception e) {
                }
            }
        }
        return strXml;
    }

    /**
     * XML转对象
     * @param className
     * @param strXml
     * @return
     */
    public static Object toObject(Class className, String strXml) {
        Object object = null;
        StringReader reader = null;
        try {
            reader = new StringReader(strXml);
            JAXBContext context = JAXBContext.newInstance(className);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            object = unmarshaller.unmarshal(reader);
        } catch (Exception e) {
        } finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
        return object;
    }

    /**
     * doc转map
     * @param doc
     * @return
     */
    public static Map<String, Object> dom2Map(Document doc) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (doc == null){
            return map;
        }

        Element root = doc.getRootElement();
        for (Iterator iterator = root.elementIterator(); iterator.hasNext(); ) {
            Element e = (Element) iterator.next();
            List list = e.elements();
            if (list.size() > 0) {
                map.put(e.getName(), dom2Map(e));
            } else{
                map.put(e.getName(), e.getText());
            }
        }
        return map;
    }

    public static Map dom2Map(Element e) {
        Map map = new HashMap();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                Element iter = (Element) list.get(i);
                List mapList = new ArrayList();

                if (iter.elements().size() > 0) {
                    Map m = dom2Map(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = new ArrayList();
                            mapList.add(obj);
                            mapList.add(m);
                        }
                        if (obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = (List) obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                    } else {
                        map.put(iter.getName(), m);
                    }
                } else {
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = new ArrayList();
                            mapList.add(obj);
                            mapList.add(iter.getText());
                        }
                        if (obj.getClass().getName().equals("java.util.ArrayList")) {
                            mapList = (List) obj;
                            mapList.add(iter.getText());
                        }
                        map.put(iter.getName(), mapList);
                    } else{
                        map.put(iter.getName(), iter.getText());
                    }

                }
            }
        } else{
            map.put(e.getName(), e.getText());
        }

        return map;
    }
    /**
     * 转化成xml, 单层无嵌套
     *
     * @param parm
     * @param isAddCDATA
     * @return
     */
    public static String xmlFormat(Map<String, String> parm, boolean isAddCDATA) {

        StringBuffer strbuff = new StringBuffer(PREFIX_XML);
        if (MapUtils.isNotEmpty(parm)) {
            for (Map.Entry<String, String> entry : parm.entrySet()) {
                strbuff.append("<").append(entry.getKey()).append(">");
                if (isAddCDATA) {
                    strbuff.append(PREFIX_CDATA);
                    if (StringUtils.isNotEmpty(entry.getValue())) {
                        strbuff.append(entry.getValue());
                    }
                    strbuff.append(SUFFIX_CDATA);
                } else {
                    if (StringUtils.isNotEmpty(entry.getValue())) {
                        strbuff.append(entry.getValue());
                    }
                }
                strbuff.append("</").append(entry.getKey()).append(">");
            }
        }
        String str = strbuff.append(SUFFIX_XML).toString();
        System.out.println("str="+str);
        return str;
    }

    /**
     * 解析xml
     *
     * @param xml
     * @return
     * @throws XmlPullParserException
     * @throws IOException
     */
    public static Map<String, String> xmlParse(String xml) throws XmlPullParserException, IOException {
        Map<String, String> map = null;
        if (StringUtils.isNotEmpty(xml)) {
            InputStream inputStream = new ByteArrayInputStream(xml.getBytes());
            XmlPullParser pullParser = XmlPullParserFactory.newInstance().newPullParser();
            pullParser.setInput(inputStream, "UTF-8"); // 为xml设置要解析的xml数据
            int eventType = pullParser.getEventType();
            System.out.println("eventType="+eventType);
            while (eventType != XmlPullParser.END_DOCUMENT) {
                switch (eventType) {
                    case XmlPullParser.START_DOCUMENT:
                        map = new HashMap<String, String>();
                        break;
                    case XmlPullParser.START_TAG:
                        String key = pullParser.getName();
                        if (key.equals("xml"))
                            break;
                        String value = pullParser.nextText().trim();
                        map.put(key, value);
                        break;
                    case XmlPullParser.END_TAG:
                        break;
                }
                eventType = pullParser.next();
            }
        }
        return map;
    }
}
