package com.qding.common.util;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

import java.util.HashSet;
import java.util.Set;

public class ObjectUtil {
    /**
     * 获取对象空属性集合
     * @param source
     * @return
     */
    public static String[] getNullPropertyNames (Object source) {
        final BeanWrapper src = new BeanWrapperImpl(source);
        java.beans.PropertyDescriptor[] pds = src.getPropertyDescriptors();
        Set<String> emptyNames = new HashSet<String>();
        for (java.beans.PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue==null) emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }
    /**
     * 根据对象非空属性拼接url
     * @param source source
     * @param exclude 排除属性
     * @return
     */
    public static String toUrlParams  (Object source,String[] exclude) {
        final BeanWrapper src = new BeanWrapperImpl(source);
        java.beans.PropertyDescriptor[] pds = src.getPropertyDescriptors();
        StringBuilder s = new StringBuilder();
        for (java.beans.PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue!=null&&srcValue!=""&& !pd.getName().equals("class")&& !ArrayUtils.contains(exclude,pd.getName())){
                s.append("&")
                        .append(pd.getName())
                        .append("=").append(srcValue);
            }
        }
        return s.toString();
    }
}
