/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.compare;

import com.ptteng.common.compare.ObjectSort;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;

public class ObjectCompareEnhanced<E>
implements Comparator<E> {
    public static final String SORT_TYPE_TIME_MILLISECOND = "time_millisecond";
    public static final String SORT_TYPE_INDICATOR_VALUE = "indicator_value";
    public static final String SORT_TYPE_COMPARABLE_VALUE = "comparable_value";
    public static final String SORT_TYPE_VALUE_INDEX = "comparable_value_index";
    public static final String DIRECT_ASC = "asc";
    public static final String DIRECT_DESC = "desc";
    private List<ObjectSort> multiSortField;

    public ObjectCompareEnhanced(List<ObjectSort> multiSortField) {
        this.multiSortField = multiSortField;
        if (null != multiSortField) {
            for (ObjectSort os : this.multiSortField) {
                os.getSortField().setAccessible(true);
            }
        }
    }

    @Override
    public int compare(E o1, E o2) {
        if (null == o1 || null == o2) {
            return 0;
        }
        int compResult = 0;
        try {
            for (ObjectSort os : this.multiSortField) {
                Comparable value1 = (Comparable)os.getSortField().get(o1);
                Comparable value2 = (Comparable)os.getSortField().get(o2);
                compResult = 0;
                compResult = SORT_TYPE_TIME_MILLISECOND.equals(os.getSortType()) ? this.compareTimeMillisecond(value1, value2, os.getDirect()) : (SORT_TYPE_INDICATOR_VALUE.equals(os.getSortType()) ? this.compareIndicatorValue(value1, value2, os.getDirect()) : (SORT_TYPE_VALUE_INDEX.equals(os.getSortType()) ? this.compareValueIndex(value1, value2, os.getSortIndexMap(), os.getDirect()) : this.compareComparableValue(value1, value2, os.getDirect())));
                if (compResult == 0) continue;
                return compResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return compResult;
    }

    private int compareTimeMillisecond(Comparable value1, Comparable value2, String direct) {
        if (null == value1 && null == value2) {
            return 0;
        }
        if (DIRECT_DESC.equalsIgnoreCase(direct)) {
            if (null != value1 && null != value2) {
                return value2.compareTo(value1);
            }
            if (null == value1) {
                return -1;
            }
            return 1;
        }
        if (null != value1 && null != value2) {
            return value1.compareTo(value2);
        }
        if (null == value1) {
            return 1;
        }
        return -1;
    }

    private int compareComparableValue(Comparable value1, Comparable value2, String direct) {
        if (null == value1 && null == value2) {
            return 0;
        }
        if (DIRECT_DESC.equalsIgnoreCase(direct)) {
            if (null != value1 && null != value2) {
                return value2.compareTo(value1);
            }
            if (null == value1) {
                return 1;
            }
            return -1;
        }
        if (null != value1 && null != value2) {
            return value1.compareTo(value2);
        }
        if (null == value1) {
            return 1;
        }
        return -1;
    }

    private int compareIndicatorValue(Comparable value1, Comparable value2, String direct) {
        if (null == value1 && null == value2) {
            return 0;
        }
        if (DIRECT_DESC.equalsIgnoreCase(direct)) {
            if (null != value1 && null != value2) {
                return NumberUtils.createBigDecimal((String)value2.toString()).compareTo(NumberUtils.createBigDecimal((String)value1.toString()));
            }
            if (null == value1) {
                return 1;
            }
            return -1;
        }
        if (null != value1 && null != value2) {
            return NumberUtils.createBigDecimal((String)value1.toString()).compareTo(NumberUtils.createBigDecimal((String)value2.toString()));
        }
        if (null == value1) {
            return 1;
        }
        return -1;
    }

    private int compareValueIndex(Comparable value1, Comparable value2, Map<Comparable, Integer> sortIndexMap, String direct) {
        Integer index1 = sortIndexMap.get(value1);
        Integer index2 = sortIndexMap.get(value2);
        if (null == index1 && null == index2) {
            return 0;
        }
        if (DIRECT_DESC.equalsIgnoreCase(direct)) {
            if (null != index1 && null != index2) {
                return index2.compareTo(index1);
            }
            if (null == index1) {
                return 1;
            }
            return -1;
        }
        if (null != index1 && null != index2) {
            return index1.compareTo(index2);
        }
        if (null == index1) {
            return 1;
        }
        return -1;
    }
}

