/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.sms.service.impl;

import com.ptteng.common.sms.service.EmailSendService;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmailSendServiceImpl
implements EmailSendService {
    protected Log log = LogFactory.getLog(this.getClass());
    private String host;
    private String port;
    private String fromMail;
    private String password;

    @Override
    public String sendEmail(String toEmail, String content, String title) {
        this.log.info((Object)("configs: host = " + this.host + ", port = " + this.port + ", fromMail = " + this.fromMail + ", password = " + this.password));
        this.log.info((Object)("arguments: toEmail = " + toEmail + ", content = " + content + ", title = " + title));
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", this.host);
        props.put("mail.smtp.port", this.port);
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.auth", "true");
        props.put("mail.smtp.ssl.enable", "false");
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EmailSendServiceImpl.this.fromMail, EmailSendServiceImpl.this.password);
            }
        };
        Session session = Session.getInstance((Properties)props, (Authenticator)auth);
        MimeMessage message = new MimeMessage(session);
        try {
            message.setFrom((Address)new InternetAddress(this.fromMail));
            InternetAddress toAddress = new InternetAddress(toEmail);
            message.setRecipient(MimeMessage.RecipientType.TO, (Address)toAddress);
            message.setSubject(title, "GB2312");
            message.setContent((Object)content, "text/html;charset=gbk");
            Transport transport = session.getTransport("smtp");
            transport.connect(this.host, this.fromMail, this.password);
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
            return message.getSubject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getFromMail() {
        return this.fromMail;
    }

    public void setFromMail(String fromMail) {
        this.fromMail = fromMail;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

