package com.ptteng.common.sms.service.impl;

import com.ptteng.common.sms.service.EmailSendService;

import javax.mail.Address;
import javax.mail.Transport;
import javax.mail.Session;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.internet.*;
import java.util.Properties;

public class EmailSendServiceImpl implements EmailSendService {
    private String host;
    private String port;
    private String fromMail;
    private String password;

    public String sendEmail(String toEmail, String content, String title) {



        // 1.创建一个程序与邮件服务器会话对象 Session
        Properties props = new Properties();

        props.setProperty("mail.smtp.host", host); // 设置主机地址smtp.163.com smtp.sina.com
        props.put("mail.smtp.port", port); //端口号
        props.setProperty("mail.transport.protocol", "smtp");// 发送邮件协议名称
        props.setProperty("mail.smtp.auth", "true");// 发送服务器需要身份验证
        props.put("mail.smtp.ssl.enable", "false");


        // 创建验证器
        Authenticator auth = new Authenticator() {
            protected  PasswordAuthentication getPasswordAuthentication() {
                // 网易邮箱Yang_li_g 用户名 hao123授权码,改为自己的账号和密码
                return new PasswordAuthentication(fromMail, password);
            }
        };

        // 使用环境属性和授权信息，创建邮件会话
        Session session = Session.getInstance(props, auth);


        // 创建邮件消息
        MimeMessage message = new MimeMessage(session);

        // 设置发件人：
        try {
            // 4.设置消息的发送者
            message.setFrom(new InternetAddress(fromMail));

            // 5.设置消息的接收者
            Address toAddress = new InternetAddress(toEmail);
            // TO 直接发送 CC抄送 BCC密送
            message.setRecipient(MimeMessage.RecipientType.TO, toAddress);

            // 6.设置主题
            message.setSubject(title,"GB2312");

            // 7.设置正文
            message.setContent(content,"text/html;charset=gbk" );

            // 8.准备发送，得到火箭
            Transport transport = session.getTransport("smtp");
            // 9.设置火箭的发射目标
            transport.connect(host, fromMail, password);//这个就是你的授权码
            // 10.发送
            transport.sendMessage(message, message.getAllRecipients());
            transport.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return "";
    }


    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getFromMail() {
        return fromMail;
    }

    public void setFromMail(String fromMail) {
        this.fromMail = fromMail;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
