package com.ptteng.common.sms.service.impl;

import com.ptteng.common.sms.service.SMSSendService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import java.util.Map;

/**
 * Created by arthur on 15/9/17.
 */
public class CommonSMSSendServiceImpl implements SMSSendService {

    protected Log log = LogFactory.getLog(this.getClass());

    private String url;
    private String account;
    private String password;

    private Map<String, String> initParams;

    @Override
    public String sendSMS(String mobile, String content) {
        HttpClient httpClient = new DefaultHttpClient();
        try {
            String url = this.url + "?account=" + account + "&password=" + password + "&mobile=" + mobile + "&content=" + content;
            HttpPost httpPost = new HttpPost(url);

            HttpResponse response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();
            log.info(System.currentTimeMillis() + "- return: " + getResponseContent(entity));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return "";
    }

    @Override
    public String sendSMSByParams(Map<String, Object> params) {
        HttpClient httpClient = new DefaultHttpClient();
        try {
            String url = this.url.concat("?");
            if (initParams != null) {
                for (Map.Entry<String, String> stringStringEntry : initParams.entrySet()) {
                    url = url.concat(stringStringEntry.getKey()).concat("=").concat(stringStringEntry.getValue().toString()).concat("&");
                }
            }
            for (Map.Entry<String, Object> stringObjectEntry : params.entrySet()) {
                url = url.concat(stringObjectEntry.getKey()).concat("=").concat(stringObjectEntry.getValue().toString()).concat("&");
            }
            HttpPost httpPost = new HttpPost(url);

            HttpResponse response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();
            log.info(System.currentTimeMillis() + "- return: " + getResponseContent(entity));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            httpClient.getConnectionManager().shutdown();
        }

        return null;
    }

    @Override
    public String sendSMSByTemplate(String mobile, String template, String[] params) {
        HttpClient httpClient = new DefaultHttpClient();
        try {
            HttpPost httpPost = new HttpPost(url);

            HttpResponse response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();
            log.info(System.currentTimeMillis() + "- return: " + getResponseContent(entity));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return "";
    }

    @Override
    public String sendSMSByTemplateByMore(String mobile, String template, Map params) {
        return null;
    }

    public static String getResponseContent(HttpEntity responseEntity) throws Exception {
        byte[] bytes = EntityUtils.toByteArray(responseEntity);
        return new String(bytes, "GBK");
    }


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }


    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInitParams(Map<String, String> initParams) {
        this.initParams = initParams;
    }

    public Map<String, String> getInitParams() {
        return initParams;
    }
}


