/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.live.service.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpRequestUtil {
    private static Log log = LogFactory.getLog(HttpRequestUtil.class);
    private static final String BOUNDARY = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
    private static final String PREFIX = "--";
    private static final String LINE_END = "\r\n";

    public static String sendGet(String url, String param) throws IOException {
        String line;
        String result = "";
        BufferedReader in = null;
        String urlNameString = url + "?" + param;
        URL realUrl = new URL(urlNameString);
        URLConnection connection = realUrl.openConnection();
        connection.setRequestProperty("accept", "*/*");
        connection.setRequestProperty("connection", "Keep-Alive");
        connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
        connection.connect();
        Map<String, List<String>> map = connection.getHeaderFields();
        for (String key : map.keySet()) {
            System.out.println(key + "--->" + map.get(key));
        }
        in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = in.readLine()) != null) {
            result = result + line;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return result;
    }

    public static String sendPost(String url, String param) throws IOException {
        String line;
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        URL realUrl = new URL(url);
        URLConnection conn = realUrl.openConnection();
        conn.setRequestProperty("accept", "*/*");
        conn.setRequestProperty("connection", "Keep-Alive");
        conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        out = new PrintWriter(conn.getOutputStream());
        out.print(param);
        out.flush();
        in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = in.readLine()) != null) {
            result = result + line;
        }
        try {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ex) {
            log.error((Object)("sendPost error,params=" + param + ",url=" + url + ",ex=" + ex));
            ex.printStackTrace();
        }
        return result;
    }

    public static String sendPost(String requestUrl, Map<String, Object> requestText, Map<String, File> requestFile) throws Exception {
        HttpURLConnection conn = null;
        InputStream input = null;
        OutputStream os = null;
        BufferedReader br = null;
        StringBuffer buffer = null;
        try {
            URL url = new URL(requestUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "*/*");
            conn.setRequestProperty("Connection", "keep-alive");
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            conn.setRequestProperty("Charset", "UTF-8");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            conn.connect();
            os = new DataOutputStream(conn.getOutputStream());
            HttpRequestUtil.writeParams(requestText, os);
            HttpRequestUtil.writeFile(requestFile, os);
            String endTarget = PREFIX + BOUNDARY + PREFIX + LINE_END;
            os.write(endTarget.getBytes());
            os.flush();
            System.out.println("======================\u54cd\u5e94\u4f53=========================");
            System.out.println("ResponseCode:" + conn.getResponseCode() + ",ResponseMessage:" + conn.getResponseMessage());
            input = conn.getResponseCode() == 200 ? conn.getInputStream() : conn.getErrorStream();
            br = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            buffer = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                buffer.append(line);
            }
            System.out.println("\u8fd4\u56de\u62a5\u6587:" + buffer.toString());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                    conn = null;
                }
                if (os != null) {
                    os.close();
                    os = null;
                }
                if (br != null) {
                    br.close();
                    br = null;
                }
            }
            catch (IOException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new Exception(ex);
            }
        }
        return buffer.toString();
    }

    private static void writeParams(Map<String, Object> requestText, OutputStream os) throws Exception {
        try {
            String msg = "\u8bf7\u6c42\u53c2\u6570\u90e8\u5206:\n";
            if (requestText == null || requestText.isEmpty()) {
                msg = msg + "\u7a7a";
            } else {
                StringBuilder requestParams = new StringBuilder();
                Set<Map.Entry<String, Object>> set = requestText.entrySet();
                for (Map.Entry<String, Object> entry : set) {
                    requestParams.append(PREFIX).append(BOUNDARY).append(LINE_END);
                    requestParams.append("Content-Disposition: form-data; name=\"").append(entry.getKey()).append("\"").append(LINE_END);
                    requestParams.append("Content-Type: text/plain; charset=utf-8").append(LINE_END);
                    requestParams.append("Content-Transfer-Encoding: 8bit").append(LINE_END);
                    requestParams.append(LINE_END);
                    requestParams.append(entry.getValue());
                    requestParams.append(LINE_END);
                }
                os.write(requestParams.toString().getBytes());
                os.flush();
                msg = msg + requestParams.toString();
            }
            System.out.println(msg);
        }
        catch (Exception e) {
            log.error((Object)"writeParams failed", (Throwable)e);
            throw new Exception(e);
        }
    }

    private static void writeFile(Map<String, File> requestFile, OutputStream os) throws Exception {
        InputStream is = null;
        try {
            String msg = "\u8bf7\u6c42\u4e0a\u4f20\u6587\u4ef6\u90e8\u5206:\n";
            if (requestFile == null || requestFile.isEmpty()) {
                msg = msg + "\u7a7a";
            } else {
                StringBuilder requestParams = new StringBuilder();
                Set<Map.Entry<String, File>> set = requestFile.entrySet();
                for (Map.Entry<String, File> entry : set) {
                    requestParams.append(PREFIX).append(BOUNDARY).append(LINE_END);
                    requestParams.append("Content-Disposition: form-data; name=\"").append(entry.getKey()).append("\"; filename=\"").append(entry.getValue().getName()).append("\"").append(LINE_END);
                    requestParams.append("Content-Type:").append(HttpRequestUtil.getContentType(entry.getValue())).append(LINE_END);
                    requestParams.append("Content-Transfer-Encoding: 8bit").append(LINE_END);
                    requestParams.append(LINE_END);
                    os.write(requestParams.toString().getBytes());
                    is = new FileInputStream(entry.getValue());
                    byte[] buffer = new byte[0x100000];
                    int len = 0;
                    while ((len = is.read(buffer)) != -1) {
                        os.write(buffer, 0, len);
                    }
                    os.write(LINE_END.getBytes());
                    os.flush();
                    msg = msg + requestParams.toString();
                }
            }
            System.out.println(msg);
        }
        catch (Exception e) {
            log.error((Object)"writeFile failed", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                log.error((Object)"writeFile FileInputStream close failed", (Throwable)e);
                throw new Exception(e);
            }
        }
    }

    public static String getContentType(File file) throws Exception {
        String streamContentType = "application/octet-stream";
        String imageContentType = "";
        ImageInputStream image = null;
        try {
            image = ImageIO.createImageInputStream(file);
            if (image == null) {
                String string = streamContentType;
                return string;
            }
            Iterator<ImageReader> it = ImageIO.getImageReaders(image);
            if (it.hasNext()) {
                String string = imageContentType = "image/" + it.next().getFormatName();
                return string;
            }
        }
        catch (IOException e) {
            log.error((Object)"method getContentType failed", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (image != null) {
                    image.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"ImageInputStream close failed", (Throwable)e);
                throw new Exception(e);
            }
        }
        return streamContentType;
    }
}

