package com.ptteng.common.live.service.util;


import org.apache.commons.codec.digest.DigestUtils;

import java.io.*;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.*;


/**
 * 获取百家云接口参数相关数据
 */
public class BaijiayunUtil {
    public static final Integer RESPONSE_SUCCESS_CODE = 0;

    /**
     * 传入实体百家云的参数包装类 获取请求参数 注意 此处需要传递实体类 不可使用vo类，否则会将序列化字段传入
     */
    public static String getUrlParam(Object object, String partnerKey) throws IllegalAccessException {
        Map<String, Object> map = invertObjectValue2Map(object);
        List<String> keyList = new ArrayList<>(map.keySet());
        Collections.sort(keyList);
        StringBuilder sb = new StringBuilder();
        for (String key : keyList) {
            Object value = map.get(key);
            sb.append(key).append("=").append(value).append("&");
        }
        sb.append("sign=").append(getSign(object, partnerKey));
        return sb.toString();
    }

    /**
     * 传入实体百家云的参数包装类，获取签名
     */
    public static String getSign(Object object, String partnerKey) throws IllegalAccessException {
        Map<String, Object> map = invertObjectValue2Map(object);
        List<String> keyList = new ArrayList<>(map.keySet());
        Collections.sort(keyList);
        StringBuilder sb = new StringBuilder();
        for (String key : keyList) {
            Object value = map.get(key);
            sb.append(key).append("=").append(value).append("&");
        }
        String signStr = sb.append("partner_key=").append(partnerKey).toString();
        return DigestUtils.md5Hex(signStr.getBytes());
    }
    /**
     * 传入实体百家云的参数包装类 获取请求参数 注意 此处需要传递实体类 不可使用vo类，否则会将序列化字段传入
     * @return
     */
    public static Map<String, Object> getRequestText(Object object, String partnerKey) throws IllegalAccessException {
        Map<String, Object> map = invertObjectValue2Map(object);
        String sign = getSign(object,partnerKey);
        map.put("sign",sign);
        return map;


    }



    /**
     * 将资源Bean中的有值的字段和值获取并保存在Map中 返回的map中没有class的字段
     * 用于生成调用百家云接口参数
     */
    public static Map<String, Object> invertObjectValue2Map(Object object) throws IllegalAccessException {
        Map<String, Object> result = new HashMap<>();
        //获得类的的属性名 数组
        Field[] fields = object.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            String name = field.getName();
            if (field.get(object) != null) {
                result.put(name,  field.get(object));
            }

        }
        return result;
    }

    /**
    * 获取秒级时间戳
    *
     *
    */
    public static Long getTimeSecond() {
        return System.currentTimeMillis() / 1000;
    }

    /**
     * 获取秒级时间戳
     * @param time 如果不传，获取当前时间的秒级时间戳
     *
     */
    public static Long getTimeSecond(Long time) {
        return time / 1000;
    }




    public static File downloadFile(File file,String urlPath) {
//        File file = null;
        try {
            // 统一资源
            URL url = new URL(urlPath);
            // 连接类的父类，抽象类
            URLConnection urlConnection = url.openConnection();
            // http的连接类
            HttpURLConnection httpURLConnection = (HttpURLConnection) urlConnection;
            //设置超时
            httpURLConnection.setConnectTimeout(1000*5);
            //设置请求方式，默认是GET
            httpURLConnection.setRequestMethod("GET");
            // 设置字符编码
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
            httpURLConnection.connect();
            // 文件大小
            int fileLength = httpURLConnection.getContentLength();

            // 控制台打印文件大小
            System.out.println("您要下载的文件大小为:" + fileLength / (1024) + "KB");

            // 建立链接从请求中获取数据
            URLConnection con = url.openConnection();
            BufferedInputStream bin = new BufferedInputStream(httpURLConnection.getInputStream());

            OutputStream out = new FileOutputStream(file);
            int size = 0;
            int len = 0;
            byte[] buf = new byte[2048];
            while ((size = bin.read(buf)) != -1) {
                len += size;
                out.write(buf, 0, size);
                // 控制台打印文件下载的百分比情况
                System.out.println("下载了-------> " + len * 100 / fileLength + "%\n");
            }
            // 关闭资源
            bin.close();
            out.close();
            System.out.println("文件下载成功！");
        } catch (MalformedURLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            System.out.println("文件下载失败！");
        } finally {
            return file;
        }

    }
}
