package com.ptteng.common.live.service;

import com.ptteng.common.live.service.vo.baijiayun.BJYDict;
import com.ptteng.common.live.service.vo.baijiayun.BJYQuery;
import com.ptteng.common.live.service.vo.baijiayun.Res;
import org.apache.poi.ss.formula.functions.T;

import java.util.List;

public interface BaijiayunLiveService {
    Res<BJYDict> createLiveRoom(BJYQuery room);
    Res<BJYDict> updateLiveRoom(BJYQuery room);
    Res<BJYDict> deleteLiveRoom(BJYQuery room);
    Res<BJYDict> getLiveRoomInfo(BJYQuery room);
    Res<BJYDict> getLiveRoomStatus(BJYQuery room);

    Res<String> getRoomList(BJYQuery room,Integer page,Integer limit);
    Res<BJYDict> getRoomCode(String roomId, Integer userNumber, String userAvatar);
    Res<BJYDict> getRoomCodeInfo(String code);
    Res<String> getRoomListCode(String roomId,Integer page,Integer limit);
    Res<BJYDict> getLiveRoomUserCount(String roomId);

    Res<BJYDict> getLiveRoomPushUrl(String roomId);
    Res<BJYDict> getLiveRoomPullUrl(String roomId);

    String sendChatMessage(T msg);
    String sendChatMessage(List<T> msgList);
    Res<String> startClass(String roomId);
    Res<String> stopClass(String roomId,Integer isKickOutAll);

    //callback
    String setClassCallbackUrl(String url);
    Res<BJYDict> getClassCallbackUrl();


    String partnerCreateKey(String secret_key,Integer regenerate);

}
