/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.esign.utils;

import com.alibaba.fastjson.JSON;
import com.ptteng.common.esign.utils.HttpRequestMethedEnum;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
    private static RequestConfig requestConfig;
    private static final int MAX_TIMEOUT = 15000;
    private static final int MAX_TOTAL = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttp(HttpRequestMethedEnum requestMethod, String url, Map<String, String> header, String params, int isHttps) {
        logger.info("\u5f00\u59cb\u53d1\u9001\uff1a=============");
        logger.info("\u8bf7\u6c42\u5934: ================");
        long beginTime = new Date().getTime();
        CloseableHttpClient httpClient = null;
        httpClient = isHttps == 1 ? HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtils.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setConnectionManagerShared(true).setDefaultRequestConfig(requestConfig).build() : HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        String responseContent = null;
        HttpRequestBase request = requestMethod.createRequest(url);
        request.setConfig(requestConfig);
        logger.info("\u53d1\u9001Http\u8bf7\u6c42\u65b9\u6cd5\uff1a" + request.getMethod());
        if (header != null) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                logger.info(entry.getKey() + "      :    " + entry.getValue());
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            if (params != null) {
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new StringEntity(params, ContentType.create((String)"application/json", (String)"utf-8")));
            }
            httpResponse = httpClient.execute((HttpUriRequest)request);
            HttpEntity httpEntity = httpResponse.getEntity();
            logger.info("\u53d1\u9001\u5730\u5740\uff1a" + request.getURI());
            logger.info("\u53d1\u9001\u5185\u5bb9\uff1a" + params);
            logger.info("\u54cd\u5e94\u72b6\u6001\uff1a" + httpResponse.getStatusLine());
            if (httpEntity != null) {
                responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                logger.info("\u54cd\u5e94\u5185\u5bb9\uff1a" + responseContent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        long endTime = new Date().getTime();
        logger.info("\u8be5\u63a5\u53e3\u54cd\u5e94\u65f6\u95f4:   " + (endTime - beginTime));
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttp2(HttpRequestMethedEnum requestMethod, String url, Map<String, String> header, Map<String, Object> params, int isHttps) {
        logger.info("\u5f00\u59cb\u53d1\u9001\uff1a=============");
        logger.info("\u8bf7\u6c42\u5934: ================");
        long beginTime = new Date().getTime();
        CloseableHttpClient httpClient = null;
        httpClient = isHttps == 1 ? HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtils.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setConnectionManagerShared(true).setDefaultRequestConfig(requestConfig).build() : HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        String responseContent = null;
        HttpRequestBase request = requestMethod.createRequest(url);
        request.setConfig(requestConfig);
        logger.info("\u53d1\u9001Http\u8bf7\u6c42\u65b9\u6cd5\uff1a" + request.getMethod());
        if (header != null) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                logger.info(entry.getKey() + "      :    " + entry.getValue());
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            if (params != null) {
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new StringEntity(JSON.toJSONString(params), ContentType.create((String)"application/json", (String)"UTF-8")));
            }
            logger.info("\u53d1\u9001\u5730\u5740\uff1a" + request.getURI());
            logger.info("\u53d1\u9001\u5185\u5bb9\uff1a" + JSON.toJSONString(params));
            httpResponse = httpClient.execute((HttpUriRequest)request);
            logger.info("\u54cd\u5e94\u72b6\u6001\uff1a" + httpResponse.getStatusLine());
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                logger.info("\u54cd\u5e94\u5185\u5bb9\uff1a" + responseContent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        long endTime = new Date().getTime();
        logger.info("\u8be5\u63a5\u53e3\u54cd\u5e94\u65f6\u95f4:   " + (endTime - beginTime));
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpput(String url, byte[] filebytes, Map<String, String> header, int isHttps) {
        logger.info("\u5f00\u59cb\u53d1\u9001\uff1a=============");
        logger.info("\u53d1\u9001\u5730\u5740: " + url);
        long beginTime = new Date().getTime();
        HttpRequestMethedEnum requestMethod = HttpRequestMethedEnum.HttpPut;
        CloseableHttpClient httpClient = null;
        httpClient = isHttps == 1 ? HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtils.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setConnectionManagerShared(true).setDefaultRequestConfig(requestConfig).build() : HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        String responseContent = null;
        HttpRequestBase request = requestMethod.createRequest(url);
        request.setConfig(requestConfig);
        logger.info("\u53d1\u9001Http\u8bf7\u6c42\u65b9\u6cd5\uff1a" + request.getMethod());
        if (header != null) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                logger.info(entry.getKey() + "      :    " + entry.getValue());
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            if (filebytes != null) {
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(filebytes));
            }
            httpResponse = httpClient.execute((HttpUriRequest)request);
            logger.info("\u54cd\u5e94\u5185\u5bb9:====================");
            HttpEntity httpEntity = httpResponse.getEntity();
            logger.info("\u54cd\u5e94\u72b6\u6001\uff1a" + httpResponse.getStatusLine());
            if (httpEntity != null) {
                responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                logger.info("\u54cd\u5e94\u5185\u5bb9\uff1a" + responseContent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        long endTime = new Date().getTime();
        logger.info("\u8be5\u63a5\u53e3\u54cd\u5e94\u65f6\u95f4:   " + (endTime - beginTime));
        return responseContent;
    }

    private static SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }

                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }
            });
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return sslsf;
    }

    static {
        connMgr.setMaxTotal(3);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(15000);
        configBuilder.setSocketTimeout(15000);
        configBuilder.setConnectionRequestTimeout(15000);
        configBuilder.setStaleConnectionCheckEnabled(true);
        requestConfig = configBuilder.build();
    }
}

