/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.esign.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static byte[] toByteArray(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            throw new FileNotFoundException(filename);
        }
        AbstractInterruptibleChannel channel = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
            channel = fs.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)((FileChannel)channel).size());
            while (((FileChannel)channel).read(byteBuffer) > 0) {
            }
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw e;
        }
        finally {
            try {
                channel.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            try {
                fs.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> download(String urlPath, String downloadDir, String fileFullName) {
        long beginTime = new Date().getTime();
        int errCode = 0;
        String msg = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        HttpURLConnection httpURLConnection = null;
        OutputStream out = null;
        BufferedInputStream bin = null;
        try {
            URL url = new URL(urlPath);
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setConnectTimeout(15000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            int fileLength = httpURLConnection.getContentLength();
            logger.info("\u60a8\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a:" + fileLength / 1024 + "KB");
            bin = new BufferedInputStream(httpURLConnection.getInputStream());
            String path = downloadDir + File.separatorChar + fileFullName;
            File file = new File(path);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
            int size = 0;
            int len = 0;
            byte[] buf = new byte[2048];
            while ((size = bin.read(buf)) != -1) {
                len += size;
                out.write(buf, 0, size);
            }
            logger.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\uff01");
        }
        catch (MalformedURLException e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01" + e.getMessage());
            errCode = -1;
            msg = "\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01" + e.getMessage();
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01" + e.getMessage());
            errCode = -1;
            msg = "\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01" + e.getMessage();
        }
        finally {
            try {
                bin.close();
                out.close();
                httpURLConnection.disconnect();
            }
            catch (Exception e) {
                logger.error("\u5173\u95edIO\u6d41\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
                errCode = -1;
                msg = "\u5173\u95edIO\u6d41\u53d1\u751f\u5f02\u5e38\uff01" + e.getMessage();
            }
        }
        map.put("errCode", errCode);
        map.put("msg", msg);
        long endTime = new Date().getTime();
        logger.info("\u6587\u6863\u4e0b\u8f7d\u7528\u65f6:" + (endTime - beginTime));
        return map;
    }

    public boolean deleteFile(String fileName) {
        if (fileName == null || fileName.equals("")) {
            logger.error("fileName\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01");
            return false;
        }
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                logger.error("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u6210\u529f\uff01");
                return true;
            }
            logger.error("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u5931\u8d25\uff01");
            return false;
        }
        logger.error("\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u5931\u8d25\uff1a" + fileName + "\u4e0d\u5b58\u5728\uff01");
        return false;
    }
}

