/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.esign.utils;

import com.ptteng.common.esign.exception.DefineException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import sun.misc.BASE64Encoder;

public class FileHelper {
    private FileHelper() {
    }

    public static byte[] getBytes(String filePath) throws DefineException {
        File file = new File(filePath);
        FileInputStream fis = null;
        byte[] buffer = null;
        try {
            fis = new FileInputStream(file);
            buffer = new byte[(int)file.length()];
            fis.read(buffer);
        }
        catch (Exception e) {
            throw new DefineException("\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25", e.getCause());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new DefineException("\u5173\u95ed\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25", e.getCause());
                }
            }
        }
        return buffer;
    }

    public static String getContentMD5(String filePath) throws DefineException {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(FileHelper.getFileMd5Bytes128(filePath));
    }

    public static String getBase64Str(String path) throws DefineException {
        InputStream is = null;
        try {
            is = new FileInputStream(new File(path));
            byte[] bytes = new byte[is.available()];
            is.read(bytes);
            String string = new BASE64Encoder().encode(bytes);
            return string;
        }
        catch (Exception e) {
            throw new DefineException("\u83b7\u53d6\u6587\u4ef6\u8f93\u5165\u6d41\u5931\u8d25", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new DefineException("\u5173\u95ed\u6587\u4ef6\u8f93\u5165\u6d41\u5931\u8d25", e);
                }
            }
        }
    }

    public static String getFileName(String path) {
        return new File(path).getName();
    }

    private static byte[] getFileMd5Bytes128(String filePath) throws DefineException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filePath));
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[fis.available()];
            int len = -1;
            while ((len = fis.read(buffer, 0, 1024)) != -1) {
                md5.update(buffer, 0, len);
            }
            byte[] byArray = md5.digest();
            return byArray;
        }
        catch (Exception e) {
            throw new DefineException("\u83b7\u53d6\u6587\u4ef6md5\u4e8c\u8fdb\u5236\u6570\u7ec4\u5931\u8d25", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new DefineException("\u5173\u95ed\u8bfb\u5199\u6d41\u5931\u8d25", e);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            String s = "d:/AAAAA.pdf";
            System.out.println(FileHelper.getContentMD5(s));
        }
        catch (DefineException e) {
            e.printStackTrace();
        }
    }
}

