package com.ptteng.common.esign.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.ptteng.common.esign.bean.flowonestep.*;
import com.ptteng.common.esign.utils.ConfigPropertiesUtil;
import com.ptteng.common.esign.utils.FileHelper;
import com.ptteng.common.esign.utils.HttpHelper;
import com.ptteng.common.esign.utils.HttpRequestMethedEnum;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SignApi {
    public static final String CRED_PSN_CH_IDCARD="CRED_PSN_CH_IDCARD";
    public static final String PDF_TYPE = "application/pdf";
    public static final String OCTET_STREAM = "application/octet-stream";
    // 日志记录器
    private Logger logger = LoggerFactory.getLogger(getClass());
    public  String appId ="";
    public  String secret="";
    public  String grantType ="client_credentials";
    public String host="";
    public String token="";


    /**
     * @description 创建个人账号 参数
     *
     *              待填充参数：
     *              <p>
     *              thirdPartyUserId: 用户唯一标识，可传入第三方平台的用户 id、证件号、手机号、邮箱等，
     *              如果设置则作为账号唯一性字段，相同信息不可重复创建。（个人用户与机构的唯一标识不可重复）【必填】
     *              <p>
     *              name:姓名【必填】
     *              <p>
     *              idType:证件类型，默认大陆身份证【可空】
     *              <p>
     *              idNumber:证件号【可空】
     *              <p>
     *              mobile:手机号【可空】
     *              <p>
     *              email:邮箱地址【可空】
     */
    public Map<String, Object> createPersonAcctParam(String thirdPartyUserId, String name, String idType, String idNumber,
                                                     String mobile, String email) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String accountId = "";
        JSONObject json = new JSONObject();
        json.put("thirdPartyUserId", thirdPartyUserId);
        json.put("name", name);
        json.put("idType", idType);
        json.put("idNumber", idNumber);
        json.put("mobile", mobile);
        json.put("email", email);

        String s_url = host.concat(ConfigPropertiesUtil.getProperty("createPersonAcctParam"));
        String res = "";
        logger.info("============创建个人签署账号==========");
        res = HttpHelper.sendPost(appId,s_url, token, json.toString());
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("accountId", accountId);
            return map;
        }
        JSONObject data = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(data.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        accountId = data.getString("accountId");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("accountId", accountId);
        map.put("data", dataMap);

        logger.info("个人账号id： " + accountId);
        logger.info("====================================");
        return map;
    }
    /**
     * @description 创建机构账号 参数
     *
     *              待填充参数：
     *              <p>
     *              thirdPartyUserId:机构唯一标识，可传入第三 方平台机构 id、企业证件 号、企业邮箱等如果设置则
     *              作为账号唯一性字段，相同 id 不可重复创建。（个人用 户与机构的唯一标识不可重 复）【必填】
     *              <p>
     *              creatorId:创建人个人账号 id（调用个 人账号创建接口返回的 accountId）【必填】
     *              <p>
     *              name：机构名称【必填】
     *              <p>
     *              idType:机构证件类型【可空】
     *              <p>
     *              idNumber:机构证件号【可空】
     *
     *
     */
    public Map<String, Object> createOrgAcct(String thirdPartyUserId, String creatorId, String name, String idType,
                                             String idNumber) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String orgId = "";
        JSONObject json = new JSONObject();
        json.put("thirdPartyUserId", thirdPartyUserId);
        json.put("creator", creatorId);
        json.put("name", name);
        json.put("idType", idType);
        json.put("idNumber", idNumber);

        String s_url = host.concat(ConfigPropertiesUtil.getProperty("createOrgAcctParam"));
        String res = "";
        logger.info("============创建结构签署账号==========");
        res = HttpHelper.sendPost(appId,s_url, token, json.toString());
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("orgId", orgId);
            return map;
        }
        JSONObject data = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(data.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        orgId = data.getString("orgId");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("orgId", orgId);
        map.put("data", dataMap);

        logger.info("机构账号id： " + orgId);
        logger.info("====================================");
        return map;
    }
    /**
     * @description 注销机构账号 参数
     *
     *              待填充参数：
     *              <p>
     *              thirdPartyUserId:机构唯一标识，可传入第三 方平台机构 id、企业证件 号、企业邮箱等如果设置则
     *              作为账号唯一性字段，相同 id 不可重复创建。（个人用 户与机构的唯一标识不可重 复）【必填】
     *              <p>
     *              orgId: 机构账号id
     *              <p>
     *
     */
    public Map<String, Object> deleteOrgAcct(String orgId,String thirdPartyUserId) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";

        String res = "";
        logger.info("============删除机构签署账号==========");

        String s_url = "";
        if (DataUtils.isNotNullOrEmpty(orgId)) {
            s_url=host.concat(ConfigPropertiesUtil.getProperty("deleteOrgByAcc").replace("{orgId}", orgId));
            res = HttpHelper.sendDelete(appId, s_url, token, null);
        } else {
            s_url = host.concat(ConfigPropertiesUtil.getProperty("deleteOrgByThirdPartyUserId")).concat("?thirdPartyUserId=").concat(thirdPartyUserId);
            res = HttpHelper.sendDelete(appId, s_url, token, null);
        }
        JSONObject jparse = JSONObject.parseObject(res);
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        logger.info("====================================");
        return map;
    }
    /**
     * @description 注销机构账号 参数
     *
     *              待填充参数：
     *              <p>
     *              thirdPartyUserId:机构唯一标识，可传入第三 方平台机构 id、企业证件 号、企业邮箱等如果设置则
     *              作为账号唯一性字段，相同 id 不可重复创建。（个人用 户与机构的唯一标识不可重 复）【必填】
     *              <p>
     *              accountId: 个人账号id
     *              <p>
     *
     */
    public Map<String, Object> deletePersonAcct(String accountId,String thirdPartyUserId) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";

        String res = "";
        logger.info("============删除个人签署账号==========");

        String s_url = "";
        if (DataUtils.isNotNullOrEmpty(accountId)) {
            s_url=host.concat(ConfigPropertiesUtil.getProperty("deletePersonByAcc").replace("{accountId}", accountId));
            res = HttpHelper.sendDelete(appId, s_url, token, null);
        } else {
            s_url=host.concat(ConfigPropertiesUtil.getProperty("deletePersonByThirdPartyUserId")).concat("?thirdPartyUserId=").concat(thirdPartyUserId);
            res = HttpHelper.sendDelete(appId, s_url, token, null);
        }
        JSONObject jparse = JSONObject.parseObject(res);
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        logger.info("====================================");
        return map;
    }
    /**
     * @description 创建个人/机构图片印章
     *
     *              待填充参数：
     *              <p>
     *              accountId: 账号
     *              <p>
     *
     *              alias: 印章别名【可空】
     *              <p>
     *              height: 印章高度，个人印章默认95，企业印章默认159【可空】
     *              <p>
     *              width: 印章宽度，个人印章默认95，企业印章默认159【可空】
     *              <p>
     *              width: 印章宽度【可空】
     *              <p>
     *              type: 印章数据类型【可空】
     *              <p>
     *              data: 印章数据【可空】
     *              <p>
     *              transparentFlag:
     *              是否对图片进行透明化处理，如图片有背景颜色，直接使用会遮挡文字，建议进行透明化处理，默认false，不做任何处理【可空】
     *
     */
    public Map<String, Object> createPicSeal(String accountId,String alias, Integer height, Integer width, String type,
                                                     String data, boolean transparentFlag) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        JSONObject json = new JSONObject();
        String sealId = "";
        json.put("alias", alias);
        json.put("height", height);
        json.put("width", width);
        json.put("type", type);
        json.put("data", data);
        json.put("transparentFlag", transparentFlag);

        String s_url = host.concat(ConfigPropertiesUtil.getProperty("createPicSeal").replace("{accountId}", accountId));
        String res = "";
        logger.info("============创建个人图片印章=========");
        res = HttpHelper.sendPost(appId,s_url, token, json.toString());
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("sealId", sealId);
            return map;
        }
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        sealId = result.getString("sealId");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("sealId", sealId);
        map.put("data", dataMap);

        logger.info("印章id： " + sealId);
        logger.info("====================================");
        return map;
    }
    /**
     * @description 查询个人印章
     *
     *              待填充参数：
     *              <p>
     *              accountId: 账号
     *              <p>
     *
     *              offset: 偏移
     *              <p>
     *              size: 数量
     *
     *
     */
    public Map<String, Object> getPersonSeals(String accountId,Integer offset,Integer size) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        JSONObject json = new JSONObject();
        String total = "";
        json.put("offset", offset);
        json.put("size", size);
        String s_url = host.concat(ConfigPropertiesUtil.getProperty("getPersonSeals").replace("{accountId}", accountId));
        String res = "";
        logger.info("============获取个人印章=========");
        res = HttpHelper.sendGet2(appId,s_url, token);
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("total", total);
            return map;
        }
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        total = result.getString("total");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("total", total);
        map.put("data", dataMap);

        logger.info("印章数量： " + total);
        logger.info("====================================");
        return map;
    }
    /**
     * @description 机构个人印章
     *
     *              待填充参数：
     *              <p>
     *              orgId: 账号
     *              <p>
     *
     *              offset: 偏移
     *              <p>
     *              size: 数量
     *
     *
     */
    public Map<String, Object> getOrgSeals(String orgId,Integer offset,Integer size) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        JSONObject json = new JSONObject();
        String total = "";
        json.put("offset", offset);
        json.put("size", size);
        String s_url = host.concat(ConfigPropertiesUtil.getProperty("getOrgSeals").replace("{orgId}", orgId));
        String res = "";
        logger.info("============获取机构印章=========");
        res = HttpHelper.sendGet2(appId,s_url, token);
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("total", total);
            return map;
        }
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        total = result.getString("total");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("total", total);
        map.put("data", dataMap);

        logger.info("印章数量： " + total);
        logger.info("====================================");
        return map;
    }

    /**
     * @description 创建机构模板印章
     *
     *              待填充参数：
     *              <p>
     *              alias: 印章别名【可空】
     *              <p>
     *              color:印章颜色【必填】
     *              <p>
     *              height：印章高度，默认159【可空】
     *              <p>
     *              width:印章宽度，默认159【可空】
     *              <p>
     *              htext：横向文【可空】
     *              <p>
     *              qtext:下弦文【可空】
     *              <p>
     *              type: 模板类型【必填】
     *              <p>
     *              central：中心图案类型【必填】
     *
     */
    public Map<String, Object> createOrgTemplateSeal(String orgId,String alias, String color, Integer height, Integer width,
                                                     String htext, String qtext, String type, String central) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String sealId = "";
        JSONObject json = new JSONObject();
        json.put("alias", alias);
        json.put("color", color);
        json.put("height", height);
        json.put("width", width);
        json.put("htext", htext);
        json.put("qtext", qtext);
        json.put("type", type);
        json.put("central", central);

        String s_url = host.concat(ConfigPropertiesUtil.getProperty("createOrgTemplateSeal").replace("{orgId}", orgId));
        String res = "";
        logger.info("============创建机构模板印章=========");
        res = HttpHelper.sendPost(appId,s_url, token, json.toString());
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("sealId", sealId);
            return map;
        }
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        sealId = result.getString("sealId");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("sealId", sealId);
        map.put("data", dataMap);

        logger.info("印章id： " + sealId);
        logger.info("====================================");
        return map;
    }

    /**
     * @description 创建个人模板印章
     *
     *              待填充参数：
     *              <p>
     *              alias: 印章别名【可空】
     *              <p>
     *              color: 印章颜色【必填】
     *              <p>
     *              height:印章高度，默认95px【可空】
     *              <p>
     *              width：印章宽度，默认95px【可空】
     *              <p>
     *              type:模板类型【必填】
     *

     */
    public Map<String, Object> addPersonTemplateSealParam(String accountId,String alias, String color, Integer height, Integer width,
                                                          String type) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String sealId = "";
        JSONObject json = new JSONObject();
        json.put("alias", alias);
        json.put("color", color);
        json.put("height", height);
        json.put("width", width);
        json.put("type", type);

        String s_url = host.concat(ConfigPropertiesUtil.getProperty("createPersonTemplateSeal").replace("{accountId}", accountId));
        String res = "";
        logger.info("============创建个人模板印章=========");
        res = HttpHelper.sendPost(appId,s_url, token, json.toString());
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("sealId", sealId);
            return map;
        }
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        sealId = result.getString("sealId");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("sealId", sealId);
        map.put("data", dataMap);

        logger.info("印章id： " + sealId);
        logger.info("====================================");
        return map;
    }


    /**
     * @description 通过模板创建签署文件
     *
     *              待填充参数：
     *              <p>
     *              name: 创建文件名
     *              <p>
     *
     *              simpleFormFields: 填充信息字符串 key控件id，value值
     *              <p>
     *              templateId: 模板id
     *
     *
     */
    public Map<String, Object> createFileByTemplate(String name,String simpleFormFields, String templateId) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        JSONObject json = new JSONObject();
        String fileId = "";
        json.put("name", name);
        json.put("simpleFormFields", JSONObject.parseObject(simpleFormFields));
        json.put("templateId", templateId);

        String s_url = host.concat(ConfigPropertiesUtil.getProperty("createFileByTemplate_URL"));
        String res = "";
        logger.info("============根据模板创建文件=========");
        res = HttpHelper.sendPost(appId,s_url, token, json.toString());
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("fileId", fileId);
            return map;
        }
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        fileId = result.getString("fileId");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("fileId", fileId);
        map.put("data", dataMap);

        logger.info("文件id： " + fileId);
        logger.info("====================================");
        return map;
    }

    /**
     * @description  创建一步签署流程
     *
     *              待填充参数：
     *              <p>
     *              copiers:抄送人
     *              <p>
     *
     *              attachments: 附件
     *              <p>
     *              docs: 待签署文件
     *              <p>
     *              flowInfo: 流程基本信息
     *              <p>
     *              signers: 签署方信息
     *
     *
     */
    public Map<String, Object> createFlowOneStep(List<Copier> copiers, List<Attachment>attachments, List<Doc> docs, FlowInfo flowInfo, List<Signer> signers) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        JSONObject json = new JSONObject();
        String flowId = "";
        json.put("attachments", attachments);
        json.put("copiers", copiers);
        json.put("docs", docs);
        json.put("flowInfo", flowInfo);
        json.put("signers", signers);
        String s_url = host.concat(ConfigPropertiesUtil.getProperty("createFlowOneStep"));
        String res = "";
        logger.info("============创建一步签署=========");
        res = HttpHelper.sendPost(appId,s_url, token, json.toString());
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("flowId", flowId);
            return map;
        }
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        flowId = result.getString("flowId");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("flowId", flowId);
        map.put("data", dataMap);

        logger.info("流程id： " + flowId);
        logger.info("====================================");
        return map;
    }



    /**
     * @description 开启签署流程
     *
     *              待填充参数：
     *              <p>
     *              flowId: 流程id
     *              <p>
     *
     */
    public Map<String, Object> startSignFlow(String flowId) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String s_url = host.concat(ConfigPropertiesUtil.getProperty("startSignFlow").replace("{flowId}",flowId));
        String res = "";
        logger.info("============开启签署流程=========");
        res = HttpHelper.sendPut(appId,s_url, token, null);
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        logger.info("====================================");
        return map;
    }
    /**
     * @description 签署流程归档
     *
     *              待填充参数：
     *              <p>s
     *              flowId: 流程id
     *              <p>
     *
     */
    public Map<String, Object> archiveFlows(String flowId) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String s_url = host.concat(ConfigPropertiesUtil.getProperty("archiveFlows").replace("{flowId}",flowId));
        String res = "";
        logger.info("============签署流程归档=========");
        res = HttpHelper.sendPut(appId,s_url, token, null);
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        logger.info("====================================");
        return map;
    }
    /**
     * @description 签署流程取消
     *
     *              待填充参数：
     *              <p>s
     *              flowId: 流程id
     *              <p>
     *
     */
    public Map<String, Object> revokeFlows(String flowId) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String s_url = host.concat(ConfigPropertiesUtil.getProperty("revokeFlows").replace("{flowId}",flowId));
        String res = "";
        logger.info("============签署流程取消=========");
        res = HttpHelper.sendPut(appId,s_url, token, null);
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        logger.info("====================================");
        return map;
    }
    /**
     * @description 通过模板创建签署文件
     *
     *              待填充参数：
     *              <p>
     *              name: 创建文件名
     *              <p>
     *
     *              simpleFormFields: 填充信息字符串 key控件id，value值
     *              <p>
     *              templateId: 模板id
     *
     *
     */
    public Map<String, Object> downloadFlowDoc(String flowId) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String fileUrl = "";

        String s_url = host.concat(ConfigPropertiesUtil.getProperty("downloadFlowDoc").replace("{flowId}",flowId));
        String res = "";
        logger.info("============下载流程文档链接=========");
        res = HttpHelper.sendGet2(appId,s_url, token);
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("fileUrl", fileUrl);
            return map;
        }
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
//        fileUrl = result.getString("fileUrl");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
//        map.put("fileUrl", fileUrl);
        map.put("data", dataMap);

//        logger.info("文件url： " + fileUrl);
        logger.info("====================================");
        return map;
    }
    /**
     * @description 设置静默签署授权
     *
     *              待填充参数：
     *              <p>
     *              accountId: 个人/机构签署账号ID，通过创建个人/机构签署账号接口获取
     *              <p>
     *              deadline: 授权截止时间, 格式为yyyy-MM-dd HH:mm:ss，默认无限期
     *
     *
     *
     */
    public Map<String, Object> signAuth(String accountId,String deadline) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";


        String s_url = host.concat(ConfigPropertiesUtil.getProperty("signAuth").replace("{accountId}",accountId));
        String res = "";
        logger.info("============设置默认签署=========");
        res = HttpHelper.sendPost(appId,s_url, token, null);
        JSONObject jparse = JSONObject.parseObject(res);
        map.put("code", jparse.get("code"));
        map.put("msg", jparse.get("message"));
        map.put("data", jparse.get("data"));
        logger.info("====================================");
        return map;
    }
    /**
     * @description 解除静默签署授权
     *
     *              待填充参数：
     *              <p>
     *              accountId: 个人/机构签署账号ID，通过创建个人/机构签署账号接口获取
     *              <p>
     *              deadline: 授权截止时间, 格式为yyyy-MM-dd HH:mm:ss，默认无限期
     *
     *
     *
     */
    public Map<String, Object> cancelSignAuth(String accountId,String deadline) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";


        String s_url = host.concat(ConfigPropertiesUtil.getProperty("signAuth").replace("{accountId}",accountId));
        String res = "";
        logger.info("============设置默认签署=========");
        res = HttpHelper.sendDelete(appId,s_url, token, null);
        JSONObject jparse = JSONObject.parseObject(res);

        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("data", dataMap);
        logger.info("====================================");
        return map;
    }


    /**
     * @description 通过上传方式创建文件
     *
     *              待填充参数：
     *              <p>
     *              filePath: 文件路径
     *              <p>
     *              fileName:  文件名
     *              <p>
     *              accountId:  账号id
     *
     *
     *
     */
    public Map<String, Object> createFileByUpload(String filePath, String fileName,String contentType,boolean convert2Pdf ) throws Exception {
        File file = new File(filePath);
        if(!file.exists()) {
            throw new Exception("文件不存在");
        }
        if (DataUtils.isNullOrEmpty(contentType)) {
            contentType = OCTET_STREAM;
        }
        JSONObject json = new JSONObject();
        json.put("contentMd5", FileHelper.getContentMD5(filePath));
        json.put("contentType", contentType);
        json.put("fileName", fileName);
        json.put("fileSize", String.valueOf(file.length()));
        json.put("convert2Pdf", convert2Pdf);

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String s_url = host.concat(ConfigPropertiesUtil.getProperty("createFileByUpload"));
        String res = "";
        logger.info("============通过上传方式创建文件=========");
        res = HttpHelper.sendPost(appId,s_url, token, json.toJSONString());
        JSONObject jparse = JSONObject.parseObject(res);
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        String uploadUrl = result.getString("uploadUrl");
        String fileId = result.getString("fileId");
        //上传
        byte[] bytes = FileHelper.getBytes(filePath);
        String contentMd5 = FileHelper.getContentMD5(filePath);
        HttpHelper.doUploadHttp(HttpRequestMethedEnum.HttpPut, uploadUrl, bytes, contentMd5,OCTET_STREAM);
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("fileId", fileId);
        map.put("data", dataMap);
        logger.info("====================================");
        return map;
    }



    /**
     * @description 查询文件上传结果
     *
     *              待填充参数：
     *              <p>
     *
     *
     *
     */
    public Map<String, Object> getFilesStatus(String fileId) throws Exception {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String s_url = host.concat(ConfigPropertiesUtil.getProperty("getFilesStatus").replace("{fileId}", fileId));
        String res = "";
        logger.info("==========文件上传结果查询=========");
        res = HttpHelper.sendGet2(appId,s_url, token);
        JSONObject jparse = JSONObject.parseObject(res);
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        Integer status = result.getInteger("status");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("status", status);
        map.put("data", dataMap);
        logger.info("====================================");
        return map;
    }


    /**
     * @description 查询、下载文件信息
     *
     *              待填充参数：
     *              <p>
     *
     *
     *
     */
    public Map<String, Object> getFilesDetail(String fileId) throws Exception {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String s_url = host.concat(ConfigPropertiesUtil.getProperty("getFilesDetail").replace("{fileId}", fileId));
        String res = "";
        logger.info("==========文件信息查询=========");
        res = HttpHelper.sendGet2(appId,s_url, token);
        JSONObject jparse = JSONObject.parseObject(res);
        JSONObject result = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(result.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        Integer status = result.getInteger("status");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("status", status);
        map.put("data", dataMap);
        logger.info("====================================");
        return map;
    }

    /**
     * @description 查询文件上传结果
     *
     *              待填充参数：
     *              <p>
     *
     *
     *
     */
    public Map<String, Object> searchWordsPosition(String fileId,String keywords) throws Exception {

        Map<String, Object> map = new HashMap();
        JSONObject json = new JSONObject();
        json.put("keywords", keywords);

        int code = 0;
        String msg = "";
        String s_url = host.concat(ConfigPropertiesUtil.getProperty("searchWordsPosition").replace("{fileId}", fileId));
        String res = "";
        logger.info("==========关键词查询=========");
        s_url=s_url.concat("?keywords=" + keywords);
        res = HttpHelper.sendGet2(appId,s_url, token);
        JSONObject jparse = JSONObject.parseObject(res);
        String data = jparse.getString("data");

        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("data", data);
        logger.info("====================================");
        return map;
    }



    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getGrantType() {
        return grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }


    public static final class SignApiBuilder {
        public  String appId ="";
        public  String secret="";
        public  String grantType ="client_credentials";
        public String host="";
        public String token="";

        private SignApiBuilder() {
        }

        public static SignApiBuilder aSignApi() {
            return new SignApiBuilder();
        }

        public SignApiBuilder withAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public SignApiBuilder withSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public SignApiBuilder withGrantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public SignApiBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public SignApiBuilder withToken(String token) {
            this.token = token;
            return this;
        }

        public SignApi build() {
            SignApi signApi = new SignApi();
            signApi.setAppId(appId);
            signApi.setSecret(secret);
            signApi.setGrantType(grantType);
            signApi.setHost(host);
            signApi.setToken(token);
            return signApi;
        }
    }
}
