package com.ptteng.common.esign.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.ptteng.common.esign.bean.BillParams;
import com.ptteng.common.esign.bean.ContextInfo;
import com.ptteng.common.esign.bean.IndivInfo;
import com.ptteng.common.esign.utils.ConfigPropertiesUtil;
import com.ptteng.common.esign.utils.HttpHelper;
import com.qding.common.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * ocr识别
 */
public class IdentityAuthApiOCR {
    // 日志记录器
    private Logger logger = LoggerFactory.getLogger(getClass());
    public  String appId ="";
    public  String secret="";
    public  String grantType ="client_credentials";
    public String host="";
    public String token="";


    public IdentityAuthApiOCR() {

    }

    /**
     * 个人2要素信息比对
     *
     * @param infoImg 身份证信息面图片BASE64字符串
     * @param emblemImg 身份证国徽面图片BASE64字符串
     * @return 包含接口响应码、接口响应结果描述和信息比对业务Id的map集合
     */
    public Map<String, Object> idcard(String infoImg, String emblemImg) {

        Map<String, Object> map = new HashMap();
        int code = 0;
        String msg = "";
        String verifyId = "";
        JSONObject jspell = new JSONObject();
        jspell.put("infoImg", infoImg);
        jspell.put("emblemImg", emblemImg);

        String s_url = host.concat(ConfigPropertiesUtil.getProperty("ocrIdCard"));
        String res = "";
        logger.info("============身份证ocr识别==========");
        res = HttpHelper.sendPost(appId,s_url, token, jspell.toString());
        JSONObject jparse = JSONObject.parseObject(res);
        code = jparse.getInteger("code");
        msg = jparse.getString("message");
        if (code != 0) {
            map.put("code", String.valueOf(code));
            map.put("msg", msg);
            map.put("verifyId", verifyId);
            return map;
        }
        JSONObject data = jparse.getJSONObject("data");
        Map<String, String> dataMap =JSONObject.parseObject(data.toJSONString(), new TypeReference<Map<String, String>>() {
        });
        verifyId = data.getString("verifyId");
        map.put("code", String.valueOf(code));
        map.put("msg", msg);
        map.put("verifyId", verifyId);
        map.put("data", dataMap);

        logger.info("信息比对业务Id： " + verifyId);
        logger.info("====================================");
        return map;
    }


    public static final class IdentityAuthApiOCRBuilder {
        public  String appId ="";
        public  String secret="";
        public  String grantType ="client_credentials";
        public String host="";
        public String token="";

        private IdentityAuthApiOCRBuilder() {
        }

        public static IdentityAuthApiOCRBuilder anIdentityAuthApiOCR() {
            return new IdentityAuthApiOCRBuilder();
        }

        public IdentityAuthApiOCRBuilder withAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public IdentityAuthApiOCRBuilder withSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public IdentityAuthApiOCRBuilder withGrantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public IdentityAuthApiOCRBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public IdentityAuthApiOCRBuilder withToken(String token) {
            this.token = token;
            return this;
        }

        public IdentityAuthApiOCR build() {
            IdentityAuthApiOCR identityAuthApiOCR = new IdentityAuthApiOCR();
            identityAuthApiOCR.grantType = this.grantType;
            identityAuthApiOCR.token = this.token;
            identityAuthApiOCR.host = this.host;
            identityAuthApiOCR.appId = this.appId;
            identityAuthApiOCR.secret = this.secret;
            return identityAuthApiOCR;
        }
    }
}
