package com.ptteng.common.esign.service;

import com.alibaba.fastjson.JSONObject;
import com.ptteng.common.esign.utils.ConfigPropertiesUtil;
import com.ptteng.common.esign.utils.HttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESignConfig {
    private final Logger logger = LoggerFactory.getLogger(getClass());
    public  String appId ="";
    public  String secret="";
    public  String grantType ="client_credentials";
    public JSONObject tokenData=null;
    //模拟环境地址
    public  String host ="https://smlopenapi.esign.cn";
    //正式环境地址
//       public  String host ="https://openapi.esign.cn";

    public  String getToken() {
        String token = "";
        if (tokenData == null || System.currentTimeMillis() - tokenData.getLong("expiresIn") > 60 * 100 * 1000) {
            logger.info("-----------获取Token------------");
            String s_url = host.concat(ConfigPropertiesUtil.getProperty("getToken").replace("{appId}", appId).replace("{secret}", secret).replace("{grantType}", grantType));
            String res = HttpHelper.sendGet(s_url);
            JSONObject jparse = JSONObject.parseObject(res);
            int code = jparse.getInteger("code");
            if (code != 0) {
                return "error";
            }
            tokenData = jparse.getJSONObject("data");

            token = tokenData.getString("token");
            logger.info("获得的token是:======== ");
            logger.info(token);
            logger.info("============================");
        } else {
            token=tokenData.getString("token");
        }

        return token ;
    }
    public  String refreshToken() {
            String token = "";
            logger.info("-----------获取Token------------");
            String s_url = host.concat(ConfigPropertiesUtil.getProperty("getToken").replace("{appId}", appId).replace("{secret}", secret).replace("{grantType}", grantType));
            String res = HttpHelper.sendGet(s_url);
            JSONObject jparse = JSONObject.parseObject(res);
            int code = jparse.getInteger("code");
            if (code != 0) {
                return "error";
            }
            tokenData = jparse.getJSONObject("data");

            token = tokenData.getString("token");
            logger.info("获得的token是:======== ");
            logger.info(token);
            logger.info("============================");
            return token ;
    }
    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getGrantType() {
        return grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public JSONObject getTokenData() {
        return tokenData;
    }

    public void setTokenData(JSONObject tokenData) {
        this.tokenData = tokenData;
    }
}
