/*
 * Decompiled with CFR 0.152.
 */
package com.dify.client;

import com.dify.client.IDifyChatClient;
import com.dify.client.IDifyClient;
import com.dify.client.IDifyDatasetClient;
import com.dify.client.IDifyWorkFlowClient;
import com.dify.client.impl.DifyBaseClientImpl;
import com.dify.client.impl.DifyChatClientImpl;
import com.dify.client.impl.DifyDatasetClientImpl;
import com.dify.client.impl.DifyWorkFlowClientImpl;

public class DifyClientBuilder {
    private String baseUrl = "http://localhost:5001";
    private String apiKey;

    public static DifyClientBuilder create() {
        return new DifyClientBuilder();
    }

    public DifyClientBuilder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public DifyClientBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public IDifyClient build() {
        if (this.baseUrl == null || this.apiKey == null) {
            throw new RuntimeException("Dify Client Build Error: params is not defined");
        }
        return new DifyBaseClientImpl(this.baseUrl, this.apiKey);
    }

    public IDifyDatasetClient buildDataset() {
        if (this.baseUrl == null || this.apiKey == null) {
            throw new RuntimeException("Dify Client Build Error: params is not defined");
        }
        return new DifyDatasetClientImpl(this.baseUrl, this.apiKey);
    }

    public IDifyChatClient buildChat() {
        if (this.baseUrl == null || this.apiKey == null) {
            throw new RuntimeException("Dify Client Build Error: params is not defined");
        }
        return new DifyChatClientImpl(this.baseUrl, this.apiKey);
    }

    public IDifyWorkFlowClient buildWorkFlow() {
        if (this.baseUrl == null || this.apiKey == null) {
            throw new RuntimeException("Dify Client Build Error: params is not defined");
        }
        return new DifyWorkFlowClientImpl(this.baseUrl, this.apiKey);
    }
}

