/*
 * Decompiled with CFR 0.152.
 */
package com.dify.client.impl;

import cn.hutool.core.net.url.UrlBuilder;
import com.alibaba.fastjson.JSONObject;
import com.dify.client.IDifyClient;
import com.dify.client.params.PathVariables;
import com.dify.client.types.DifyFileResult;
import com.dify.routes.DifyRoutes;
import com.dify.routes.HttpMethod;
import com.dify.types.DifyException;
import com.dify.types.DifyRoute;
import com.dify.types.ResponseMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DifyBaseClientImpl
implements IDifyClient {
    private final String server;
    private final String apiKey;
    private static final Log log = LogFactory.getLog(DifyBaseClientImpl.class);

    public DifyBaseClientImpl(String server, String apiKey) {
        this.apiKey = apiKey;
        this.server = server;
    }

    @Override
    public String getAppInfo() throws DifyException, IOException {
        return this.requestJson(DifyRoutes.INFO);
    }

    @Override
    public String getAppParameters() throws DifyException, IOException {
        return this.requestJson(DifyRoutes.PARAMETERS);
    }

    @Override
    public String getAppMetaInfo() throws DifyException, IOException {
        return this.requestJson(DifyRoutes.META_INFO);
    }

    @Override
    public DifyFileResult uploadFile(File file, String user) throws DifyException, IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("file", file);
        data.put("user", user);
        String result = this.requestMultipart(DifyRoutes.FILE_UPLOAD, null, data);
        return (DifyFileResult)JSONObject.parseObject((String)result, DifyFileResult.class);
    }

    @Override
    public String sendBlocking(DifyRoute route, Map<String, Object> params) throws DifyException, IOException {
        return this.sendBlocking(route, null, params);
    }

    @Override
    public String sendBlocking(DifyRoute route, Map<String, Object> query, Map<String, Object> params) throws DifyException, IOException {
        params.put("response_mode", (Object)ResponseMode.blocking);
        return this.requestJson(route, query, params);
    }

    @Override
    public CompletableFuture<Void> sendStreaming(DifyRoute route, Map<String, Object> params, Consumer<String> consumer) {
        return this.sendStreaming(route, null, null, params, consumer);
    }

    @Override
    public CompletableFuture<Void> sendStreaming(DifyRoute route, Map<String, Object> query, Map<String, Object> params, Consumer<String> consumer) {
        return this.sendStreaming(route, null, query, params, consumer);
    }

    @Override
    public CompletableFuture<Void> sendStreaming(final DifyRoute route, final List<PathVariables> pathVariables, final Map<String, Object> query, final Map<String, Object> params, final Consumer<String> consumer) {
        params.put("response_mode", (Object)ResponseMode.streaming);
        log.info((Object)("sendStreaming: route:" + route + " params:" + JSONObject.toJSONString(params) + " query:" + JSONObject.toJSONString(query)));
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    String inputLine;
                    String url = route.getUrl();
                    String resolvedUrl = DifyBaseClientImpl.this.resolvePathVariables(url, pathVariables);
                    HttpURLConnection connection = DifyBaseClientImpl.this.buildConnection(resolvedUrl, query, route.getMethod());
                    if (route.getMethod() == HttpMethod.GET) {
                        connection.setRequestMethod("GET");
                    } else {
                        connection.setRequestMethod("POST");
                        connection.setRequestProperty("Content-Type", "application/json");
                        OutputStream os = connection.getOutputStream();
                        os.write(JSONObject.toJSONString((Object)params).getBytes());
                        os.flush();
                        os.close();
                    }
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder content = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        content.append(inputLine);
                        if (!inputLine.startsWith("data:")) continue;
                        consumer.accept(inputLine.substring("data:".length()).trim());
                    }
                    in.close();
                    connection.disconnect();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public String requestJson(DifyRoute route) throws DifyException, IOException {
        return this.requestJson(route.getUrl(), route.getMethod(), null, null, null);
    }

    @Override
    public String requestJson(DifyRoute route, Map<String, Object> query) throws DifyException, IOException {
        return this.requestJson(route.getUrl(), route.getMethod(), null, query, null);
    }

    @Override
    public String requestJson(DifyRoute route, Map<String, Object> query, Object params) throws DifyException, IOException {
        return this.requestJson(route.getUrl(), route.getMethod(), null, query, params);
    }

    @Override
    public String requestJson(String url, HttpMethod method, Map<String, Object> query, Object params) throws DifyException, IOException {
        return this.requestJson(url, method, null, query, params);
    }

    @Override
    public String requestJson(DifyRoute route, List<PathVariables> pathVariables) throws DifyException, IOException, InterruptedException {
        return this.requestJson(route.getUrl(), route.getMethod(), pathVariables, null, null);
    }

    @Override
    public String requestJson(DifyRoute route, List<PathVariables> pathVariables, Map<String, Object> query) throws DifyException, IOException, InterruptedException {
        return this.requestJson(route.getUrl(), route.getMethod(), pathVariables, query, null);
    }

    @Override
    public String requestJson(DifyRoute route, List<PathVariables> pathVariables, Map<String, Object> query, Object params) throws DifyException, IOException, InterruptedException {
        return this.requestJson(route.getUrl(), route.getMethod(), pathVariables, query, params);
    }

    @Override
    public String requestJson(String url, HttpMethod method, List<PathVariables> pathVariables, Map<String, Object> query, Object params) throws DifyException, IOException {
        String inputLine;
        log.info((Object)("requestJson: url" + url + " method:" + (Object)((Object)method) + " pathVariables:" + JSONObject.toJSONString(pathVariables) + " query:" + JSONObject.toJSONString(query) + " params:" + JSONObject.toJSONString((Object)params)));
        String resolvedUrl = this.resolvePathVariables(url, pathVariables);
        log.info((Object)("request url: " + resolvedUrl));
        HttpURLConnection connection = this.buildConnection(resolvedUrl, query, method);
        log.info((Object)("connection requestProperty:" + JSONObject.toJSONString(connection.getRequestProperties())));
        if (method == HttpMethod.GET || method == HttpMethod.DELETE) {
            connection.setRequestMethod(method.toString());
        } else {
            connection.setRequestMethod(method.toString());
            connection.setRequestProperty("Content-Type", "application/json");
            OutputStream os = connection.getOutputStream();
            os.write(JSONObject.toJSONString((Object)params).getBytes());
            os.flush();
            os.close();
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        connection.disconnect();
        if (connection.getResponseCode() >= 400) {
            throw new DifyException(content.toString(), connection.getResponseCode());
        }
        log.info((Object)("responseJson: " + content.toString()));
        return content.toString();
    }

    @Override
    public String requestMultipart(DifyRoute route, Map<String, Object> query, Map<String, Object> params) throws DifyException, IOException {
        return this.requestMultipart(route.getUrl(), route.getMethod(), null, query, params);
    }

    @Override
    public String requestMultipart(DifyRoute route, List<PathVariables> pathVariables, Map<String, Object> query, Map<String, Object> params) throws DifyException, IOException {
        return this.requestMultipart(route.getUrl(), route.getMethod(), pathVariables, query, params);
    }

    @Override
    public String requestMultipart(String url, HttpMethod method, List<PathVariables> pathVariables, Map<String, Object> query, Map<String, Object> params) throws DifyException, IOException {
        String inputLine;
        String resolvedUrl = this.resolvePathVariables(url, pathVariables);
        HttpURLConnection connection = this.buildConnection(url, query, method);
        String boundary = "-----------" + UUID.randomUUID().toString().replaceAll("-", "");
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        OutputStream os = connection.getOutputStream();
        os.write(this.convertMapToMultipart(boundary, params).getBytes());
        os.flush();
        os.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        connection.disconnect();
        if (connection.getResponseCode() >= 400) {
            throw new DifyException(content.toString(), connection.getResponseCode());
        }
        return content.toString();
    }

    private HttpURLConnection buildConnection(String url, Map<String, Object> query, HttpMethod method) throws IOException {
        url = this.server + url;
        UrlBuilder urlBuilder = UrlBuilder.ofHttp((String)url);
        if (query != null && !query.isEmpty()) {
            StringBuilder urlStringBuilder = new StringBuilder(url);
            boolean isFirst = true;
            for (Map.Entry<String, Object> entry : query.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null || key == null) continue;
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object item : list) {
                        if (isFirst && !url.contains("?")) {
                            urlStringBuilder.append("?");
                            isFirst = false;
                        } else {
                            urlStringBuilder.append("&");
                        }
                        try {
                            String encodedKey = URLEncoder.encode(key, "UTF-8");
                            String encodedValue = URLEncoder.encode(item.toString(), "UTF-8");
                            urlStringBuilder.append(encodedKey).append("=").append(encodedValue);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    continue;
                }
                if (isFirst && !url.contains("?")) {
                    urlStringBuilder.append("?");
                    isFirst = false;
                } else {
                    urlStringBuilder.append("&");
                }
                try {
                    String encodedKey = URLEncoder.encode(key, "UTF-8");
                    String encodedValue = URLEncoder.encode(value.toString(), "UTF-8");
                    urlStringBuilder.append(encodedKey).append("=").append(encodedValue);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            url = urlStringBuilder.toString();
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("Authorization", "Bearer " + this.apiKey);
        connection.setDoOutput(true);
        return connection;
    }

    private String convertMapToMultipart(String boundary, Map<String, Object> data) throws IOException {
        StringBuilder body = new StringBuilder();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Path || value instanceof File) {
                Path filePath = value instanceof Path ? (Path)value : ((File)value).toPath();
                String fileName = filePath.getFileName().toString();
                byte[] fileBytes = Files.readAllBytes(filePath);
                String mimeType = Files.probeContentType(filePath);
                body.append("--").append(boundary).append("\r\n").append("Content-Disposition: form-data; name=\"").append(key).append("\"; filename=\"").append(fileName).append("\"\r\n").append("Content-Type: ").append(mimeType != null ? mimeType : "application/octet-stream").append("\r\n\r\n").append(new String(fileBytes)).append("\r\n");
                continue;
            }
            body.append("--").append(boundary).append("\r\n").append("Content-Disposition: form-data; name=\"").append(key).append("\"\r\n").append("Content-Type: text/plain\r\n\r\n").append(value).append("\r\n");
        }
        body.append("--").append(boundary).append("--\r\n");
        return body.toString();
    }

    private String resolvePathVariables(String url, List<PathVariables> pathVariables) {
        if (url == null || url.isEmpty() || pathVariables == null || pathVariables.isEmpty()) {
            return url;
        }
        for (PathVariables pv : pathVariables) {
            if (pv.getName() == null || pv.getValue() == null) continue;
            url = url.replace("{" + pv.getName() + "}", pv.getValue());
        }
        return url;
    }
}

