/*
 * Decompiled with CFR 0.152.
 */
package com.dify.client.params.documents;

import com.alibaba.fastjson.annotation.JSONField;
import com.dify.client.params.documents.PreProcessingRules;
import com.dify.client.params.documents.ProcessingRule;
import com.dify.client.params.documents.RerankingModel;
import com.dify.client.params.documents.RetrievalModel;
import com.dify.client.params.documents.Rules;
import com.dify.client.params.documents.Segmentation;
import com.dify.client.params.documents.SubchunkSegmentation;
import java.util.ArrayList;

public class AddDocumentRequest {
    private String name;
    private String text;
    @JSONField(name="indexing_technique")
    private String indexingTechnique;
    @JSONField(name="doc_form")
    private String docForm;
    @JSONField(name="doc_language")
    private String docLanguage;
    @JSONField(name="process_rule")
    private ProcessingRule processRule;
    @JSONField(name="retrieval_model")
    private RetrievalModel retrievalModel;
    @JSONField(name="embedding_model")
    private String embeddingModel;
    @JSONField(name="embedding_model_provider")
    private String embeddingModelProvider;

    public AddDocumentRequest(String name, String text, Boolean defaultLibrary, Boolean isFirst) {
        this.name = name;
        this.text = text;
        if (defaultLibrary.booleanValue()) {
            this.indexingTechnique = "high_quality";
            this.docForm = "hierarchical_model";
            this.docLanguage = "Chinese";
            ArrayList<PreProcessingRules> preProcessingRules = new ArrayList<PreProcessingRules>();
            preProcessingRules.add(PreProcessingRules.builder().id("remove_extra_spaces").enabled(true).build());
            preProcessingRules.add(PreProcessingRules.builder().id("remove_urls_emails").enabled(false).build());
            Rules rules = Rules.builder().preProcessingRules(preProcessingRules).segmentation(Segmentation.builder().separator("*****").maxTokens(1000).build()).parentMode("paragraph").subchunkSegmentation(SubchunkSegmentation.builder().separator("****").maxTokens(500).build()).build();
            this.processRule = ProcessingRule.builder().mode("hierarchical").rules(rules).build();
            if (isFirst.booleanValue()) {
                this.retrievalModel = RetrievalModel.builder().searchMethod("hybrid_search").rerankingEnable(true).topK(10).scoreThresholdEnabled(true).scoreThreshold(Float.valueOf(0.3f)).rerankingModel(RerankingModel.builder().rerankingProviderName("langgenius/tongyi/tongyi").rerankingModelName("gte-rerank").build()).build();
                this.embeddingModel = "hunyuan-embedding";
                this.embeddingModelProvider = "langgenius/hunyuan/hunyuan";
            }
        }
    }

    public static AddDocumentRequestBuilder builder() {
        return new AddDocumentRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public String getIndexingTechnique() {
        return this.indexingTechnique;
    }

    public String getDocForm() {
        return this.docForm;
    }

    public String getDocLanguage() {
        return this.docLanguage;
    }

    public ProcessingRule getProcessRule() {
        return this.processRule;
    }

    public RetrievalModel getRetrievalModel() {
        return this.retrievalModel;
    }

    public String getEmbeddingModel() {
        return this.embeddingModel;
    }

    public String getEmbeddingModelProvider() {
        return this.embeddingModelProvider;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setIndexingTechnique(String indexingTechnique) {
        this.indexingTechnique = indexingTechnique;
    }

    public void setDocForm(String docForm) {
        this.docForm = docForm;
    }

    public void setDocLanguage(String docLanguage) {
        this.docLanguage = docLanguage;
    }

    public void setProcessRule(ProcessingRule processRule) {
        this.processRule = processRule;
    }

    public void setRetrievalModel(RetrievalModel retrievalModel) {
        this.retrievalModel = retrievalModel;
    }

    public void setEmbeddingModel(String embeddingModel) {
        this.embeddingModel = embeddingModel;
    }

    public void setEmbeddingModelProvider(String embeddingModelProvider) {
        this.embeddingModelProvider = embeddingModelProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDocumentRequest)) {
            return false;
        }
        AddDocumentRequest other = (AddDocumentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$indexingTechnique = this.getIndexingTechnique();
        String other$indexingTechnique = other.getIndexingTechnique();
        if (this$indexingTechnique == null ? other$indexingTechnique != null : !this$indexingTechnique.equals(other$indexingTechnique)) {
            return false;
        }
        String this$docForm = this.getDocForm();
        String other$docForm = other.getDocForm();
        if (this$docForm == null ? other$docForm != null : !this$docForm.equals(other$docForm)) {
            return false;
        }
        String this$docLanguage = this.getDocLanguage();
        String other$docLanguage = other.getDocLanguage();
        if (this$docLanguage == null ? other$docLanguage != null : !this$docLanguage.equals(other$docLanguage)) {
            return false;
        }
        ProcessingRule this$processRule = this.getProcessRule();
        ProcessingRule other$processRule = other.getProcessRule();
        if (this$processRule == null ? other$processRule != null : !((Object)this$processRule).equals(other$processRule)) {
            return false;
        }
        RetrievalModel this$retrievalModel = this.getRetrievalModel();
        RetrievalModel other$retrievalModel = other.getRetrievalModel();
        if (this$retrievalModel == null ? other$retrievalModel != null : !((Object)this$retrievalModel).equals(other$retrievalModel)) {
            return false;
        }
        String this$embeddingModel = this.getEmbeddingModel();
        String other$embeddingModel = other.getEmbeddingModel();
        if (this$embeddingModel == null ? other$embeddingModel != null : !this$embeddingModel.equals(other$embeddingModel)) {
            return false;
        }
        String this$embeddingModelProvider = this.getEmbeddingModelProvider();
        String other$embeddingModelProvider = other.getEmbeddingModelProvider();
        return !(this$embeddingModelProvider == null ? other$embeddingModelProvider != null : !this$embeddingModelProvider.equals(other$embeddingModelProvider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddDocumentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $indexingTechnique = this.getIndexingTechnique();
        result = result * 59 + ($indexingTechnique == null ? 43 : $indexingTechnique.hashCode());
        String $docForm = this.getDocForm();
        result = result * 59 + ($docForm == null ? 43 : $docForm.hashCode());
        String $docLanguage = this.getDocLanguage();
        result = result * 59 + ($docLanguage == null ? 43 : $docLanguage.hashCode());
        ProcessingRule $processRule = this.getProcessRule();
        result = result * 59 + ($processRule == null ? 43 : ((Object)$processRule).hashCode());
        RetrievalModel $retrievalModel = this.getRetrievalModel();
        result = result * 59 + ($retrievalModel == null ? 43 : ((Object)$retrievalModel).hashCode());
        String $embeddingModel = this.getEmbeddingModel();
        result = result * 59 + ($embeddingModel == null ? 43 : $embeddingModel.hashCode());
        String $embeddingModelProvider = this.getEmbeddingModelProvider();
        result = result * 59 + ($embeddingModelProvider == null ? 43 : $embeddingModelProvider.hashCode());
        return result;
    }

    public String toString() {
        return "AddDocumentRequest(name=" + this.getName() + ", text=" + this.getText() + ", indexingTechnique=" + this.getIndexingTechnique() + ", docForm=" + this.getDocForm() + ", docLanguage=" + this.getDocLanguage() + ", processRule=" + this.getProcessRule() + ", retrievalModel=" + this.getRetrievalModel() + ", embeddingModel=" + this.getEmbeddingModel() + ", embeddingModelProvider=" + this.getEmbeddingModelProvider() + ")";
    }

    public AddDocumentRequest() {
    }

    public AddDocumentRequest(String name, String text, String indexingTechnique, String docForm, String docLanguage, ProcessingRule processRule, RetrievalModel retrievalModel, String embeddingModel, String embeddingModelProvider) {
        this.name = name;
        this.text = text;
        this.indexingTechnique = indexingTechnique;
        this.docForm = docForm;
        this.docLanguage = docLanguage;
        this.processRule = processRule;
        this.retrievalModel = retrievalModel;
        this.embeddingModel = embeddingModel;
        this.embeddingModelProvider = embeddingModelProvider;
    }

    public static class AddDocumentRequestBuilder {
        private String name;
        private String text;
        private String indexingTechnique;
        private String docForm;
        private String docLanguage;
        private ProcessingRule processRule;
        private RetrievalModel retrievalModel;
        private String embeddingModel;
        private String embeddingModelProvider;

        AddDocumentRequestBuilder() {
        }

        public AddDocumentRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AddDocumentRequestBuilder text(String text) {
            this.text = text;
            return this;
        }

        public AddDocumentRequestBuilder indexingTechnique(String indexingTechnique) {
            this.indexingTechnique = indexingTechnique;
            return this;
        }

        public AddDocumentRequestBuilder docForm(String docForm) {
            this.docForm = docForm;
            return this;
        }

        public AddDocumentRequestBuilder docLanguage(String docLanguage) {
            this.docLanguage = docLanguage;
            return this;
        }

        public AddDocumentRequestBuilder processRule(ProcessingRule processRule) {
            this.processRule = processRule;
            return this;
        }

        public AddDocumentRequestBuilder retrievalModel(RetrievalModel retrievalModel) {
            this.retrievalModel = retrievalModel;
            return this;
        }

        public AddDocumentRequestBuilder embeddingModel(String embeddingModel) {
            this.embeddingModel = embeddingModel;
            return this;
        }

        public AddDocumentRequestBuilder embeddingModelProvider(String embeddingModelProvider) {
            this.embeddingModelProvider = embeddingModelProvider;
            return this;
        }

        public AddDocumentRequest build() {
            return new AddDocumentRequest(this.name, this.text, this.indexingTechnique, this.docForm, this.docLanguage, this.processRule, this.retrievalModel, this.embeddingModel, this.embeddingModelProvider);
        }

        public String toString() {
            return "AddDocumentRequest.AddDocumentRequestBuilder(name=" + this.name + ", text=" + this.text + ", indexingTechnique=" + this.indexingTechnique + ", docForm=" + this.docForm + ", docLanguage=" + this.docLanguage + ", processRule=" + this.processRule + ", retrievalModel=" + this.retrievalModel + ", embeddingModel=" + this.embeddingModel + ", embeddingModelProvider=" + this.embeddingModelProvider + ")";
        }
    }
}

