/*
 * Decompiled with CFR 0.152.
 */
package com.dify.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dify.client.IDifyChatClient;
import com.dify.client.impl.DifyBaseClientImpl;
import com.dify.client.params.ParamMessage;
import com.dify.client.types.DifyChatResult;
import com.dify.routes.DifyRoutes;
import com.dify.routes.HttpMethod;
import com.dify.types.DifyException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DifyChatClientImpl
extends DifyBaseClientImpl
implements IDifyChatClient {
    private static final Log log = LogFactory.getLog(DifyChatClientImpl.class);

    public DifyChatClientImpl(String server, String apiKey) {
        super(server, apiKey);
    }

    @Override
    public DifyChatResult sendMessages(ParamMessage message) {
        try {
            log.info((Object)("sendMessages: " + message));
            String result = this.sendBlocking(DifyRoutes.CHAT_CHAT_MESSAGES, message.toMap());
            return DifyChatResult.builder().event("message").payload(JSON.parseObject((String)result)).build();
        }
        catch (DifyException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"sendMessages", (Throwable)e);
            throw new DifyException("\u6d88\u606f\u53d1\u9001\u5f02\u5e38", 500);
        }
    }

    @Override
    public CompletableFuture<Void> sendMessagesAsync(ParamMessage message, final Consumer<DifyChatResult> consumer) {
        return this.sendStreaming(DifyRoutes.CHAT_CHAT_MESSAGES, message.toMap(), new Consumer<String>(){

            @Override
            public void accept(String line) {
                JSONObject json = JSON.parseObject((String)line);
                consumer.accept(DifyChatResult.builder().event(json.getString("event")).payload(json).build());
            }
        });
    }

    @Override
    public Boolean stopResponse(String taskId, String user) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("user", user);
            String result = this.requestJson(String.format("%s/%s/stop", DifyRoutes.CHAT_CHAT_MESSAGES.getUrl(), taskId), HttpMethod.POST, null, params);
            JSONObject json = JSON.parseObject((String)result);
            return "success".equals(json.getString("result"));
        }
        catch (DifyException e) {
            log.error((Object)"stopResponse: {}", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"stopResponse", (Throwable)e);
        }
        return false;
    }

    @Override
    public List<String> suggestedList(String messageId, String user) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("user", user);
            String result = this.requestJson(String.format("%s/%s/suggested", DifyRoutes.CHAT_MESSAGES.getUrl(), messageId), HttpMethod.GET, params, null);
            JSONObject json = JSON.parseObject((String)result);
            if ("success".equals(json.getString("result"))) {
                if (json.getJSONArray("data") == null) {
                    return new ArrayList<String>();
                }
                ArrayList<String> list = new ArrayList<String>();
                for (Object o : json.getJSONArray("data")) {
                    list.add(o.toString());
                }
                return list;
            }
            return new ArrayList<String>();
        }
        catch (DifyException e) {
            log.error((Object)"suggestedList: {}", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"suggestedList", (Throwable)e);
        }
        return null;
    }

    @Override
    public JSONObject history(String conversationId, String user, Integer limit, String firstId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("conversation_id", conversationId);
            params.put("user", user);
            params.put("limit", limit);
            params.put("first_id", firstId);
            String result = this.requestJson(DifyRoutes.CHAT_MESSAGES, params, null);
            if (result == null) {
                return null;
            }
            return JSON.parseObject((String)result);
        }
        catch (DifyException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"history", (Throwable)e);
            throw new DifyException("\u83b7\u53d6\u4f1a\u8bdd\u5386\u53f2\u6d88\u606f\u5f02\u5e38", 500);
        }
    }

    @Override
    public JSONObject conversations(String user, Integer limit, String sortBy, String lastId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("user", user);
            params.put("last_id", lastId);
            params.put("sort_by", sortBy);
            params.put("limit", limit);
            String result = this.requestJson(DifyRoutes.CHAT_CONVERSATIONS, params, null);
            if (result == null) {
                return null;
            }
            return JSON.parseObject((String)result);
        }
        catch (DifyException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"conversations", (Throwable)e);
            throw new DifyException("\u83b7\u53d6\u4f1a\u8bdd\u5217\u8868\u5f02\u5e38", 500);
        }
    }

    @Override
    public Boolean deleteConversation(String conversationId, String user) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("user", user);
            String result = this.requestJson(DifyRoutes.CHAT_CONVERSATIONS.getUrl() + "/" + conversationId, HttpMethod.DELETE, null, params);
            JSONObject json = JSON.parseObject((String)result);
            return "success".equals(json.getString("result"));
        }
        catch (DifyException e) {
            log.error((Object)"deleteConversation", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"deleteConversation", (Throwable)e);
        }
        return false;
    }

    @Override
    public JSONObject renameConversation(String conversationId, String user, String name) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("user", user);
            params.put("name", name);
            params.put("auto_generate", false);
            String result = this.requestJson(String.format("%s/%s/name", DifyRoutes.CHAT_CONVERSATIONS.getUrl(), conversationId), HttpMethod.POST, null, params);
            return JSON.parseObject((String)result);
        }
        catch (DifyException e) {
            log.error((Object)"renameConversation: {}", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"renameConversation", (Throwable)e);
        }
        return null;
    }

    @Override
    public String audioToText(File file, String user) throws DifyException, IOException, InterruptedException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("file", file);
        data.put("user", user);
        JSONObject result = JSON.parseObject((String)this.requestMultipart(DifyRoutes.AUDIO_TO_TEXT, null, data));
        return result.getString("text");
    }
}

