-- ----------------------------
-- Table structure for `user_operation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_operation`;
CREATE TABLE `user_operation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint NOT NULL   COMMENT '用户id',  
    `pattern` int NOT NULL   COMMENT '模式',  
    `strength` int NOT NULL   COMMENT '强度',  
    `use_time` int NOT NULL   COMMENT '使用时间',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人ID',  
    `update_by` bigint NOT NULL   COMMENT '更新人ID',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `height` bigint NOT NULL   COMMENT '身高',
    `weight` bigint NOT NULL   COMMENT '体重',
    `age` int NOT NULL   COMMENT '年龄',
    `name` varchar(15) NOT NULL   COMMENT '名称',
    `wx_name` varchar(15) NOT NULL   COMMENT '微信名称',
    `not_bow` varchar(15)    COMMENT '不后弓',
    `sit_upright` varchar(15)    COMMENT '坐正直',
    `not_forward` varchar(15)    COMMENT '不前倾',
    `posture_time` varchar(15)    COMMENT '正坐姿久坐时间提醒',
    `posture_music` varchar(15)    COMMENT '正坐姿背景音乐',
    `massage_time` varchar(15)    COMMENT '轻按摩自动停止时间',
    `massage_music` varchar(15)    COMMENT '轻按摩背景音乐',
    `sex` int    COMMENT '性别',
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人ID',  
    `update_by` bigint NOT NULL   COMMENT '更新人ID',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_openid_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_openid_relation`;
CREATE TABLE `user_openid_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint NOT NULL   COMMENT '用户id',  
    `openid` varchar(50) NOT NULL   COMMENT 'openid',  
    `type` varchar(20) NOT NULL   COMMENT '类型',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人ID',  
    `update_by` bigint NOT NULL   COMMENT '更新人ID',  
    `frequency` bigint     COMMENT '正姿势超出角度次数',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





