/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.cashew.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.cashew.home.model.UserOperation;
import com.ptteng.cashew.home.service.UserOperationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserOperationServiceImpl
extends BaseDaoServiceImpl
implements UserOperationService {
    private static final Log log = LogFactory.getLog(UserOperationServiceImpl.class);

    public Long insert(UserOperation userOperation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userOperation));
        if (userOperation == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userOperation.setCreateAt(Long.valueOf(currentTimeMillis));
        userOperation.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userOperation);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userOperation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserOperation> insertList(List<UserOperation> userOperationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userOperationList == null ? "null" : Integer.valueOf(userOperationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userOperationList)) {
            return new ArrayList<UserOperation>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOperation userOperation : userOperationList) {
            userOperation.setCreateAt(Long.valueOf(currentTimeMillis));
            userOperation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userOperationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userOperationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserOperation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserOperation userOperation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userOperation == null ? "null" : userOperation.getId())));
        boolean result = false;
        if (userOperation == null) {
            return true;
        }
        userOperation.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userOperation);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userOperation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userOperation));
        }
        return result;
    }

    public boolean updateList(List<UserOperation> userOperationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userOperationList == null ? "null" : Integer.valueOf(userOperationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userOperationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOperation userOperation : userOperationList) {
            userOperation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userOperationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userOperationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userOperationList.size()));
        return result;
    }

    public UserOperation getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserOperation userOperation = null;
        if (id == null) {
            return userOperation;
        }
        try {
            userOperation = (UserOperation)this.dao.get(UserOperation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userOperation;
    }

    public List<UserOperation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userOperation = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOperation>();
        }
        try {
            userOperation = this.dao.getList(UserOperation.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userOperation == null ? "null" : Integer.valueOf(userOperation.size()))));
        return userOperation;
    }

    public List<Long> getUserOperationIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOperationIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOperationIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOperationIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserOperationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOperationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOperationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserOperationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserOperationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

