/**
 * 
 */
package com.ptteng.sca.common.carjn.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.carjn.model.Indent;
import com.ptteng.common.carjn.service.IndentService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class IndentSCAClient implements IndentService {

    private IndentService indentService;

	public IndentService getIndentService() {
		return indentService;
	}
	
	
	public void setIndentService(IndentService indentService) {
		this.indentService =indentService;
	}
	
	
			   
		@Override
		public Long insert(Indent indent)throws ServiceException, ServiceDaoException{
		
		return indentService.insert(indent);
		          
		
		}	
		  
    	   
		@Override
		public List<Indent> insertList(List<Indent> indentList)throws ServiceException, ServiceDaoException{
		
		return indentService.insertList(indentList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return indentService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Indent indent)throws ServiceException, ServiceDaoException{
		
		return indentService.update(indent);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Indent> indentList)throws ServiceException, ServiceDaoException{
		
		return indentService.updateList(indentList);
		          
		
		}	
		  
    	   
		@Override
		public Indent getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return indentService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Indent> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return indentService.getObjectsByIds(ids);
		          
		
		}


	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIndentIdsBySalerIdOrderByUpdateAt(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return indentService.getIndentIdsBySalerIdOrderByUpdateAt(salerId, start, limit);
	
	
	}

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIndentIdsBySalerIdOrderByUpdateAtAsc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return indentService.getIndentIdsBySalerIdOrderByUpdateAtAsc(salerId, start, limit);


	}

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIndentIdsBySalerIdOrderByAmount(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return indentService.getIndentIdsBySalerIdOrderByAmount(salerId, start, limit);


	}

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIndentIdsBySalerIdOrderByAmountAsc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return indentService.getIndentIdsBySalerIdOrderByAmountAsc(salerId, start, limit);


	}


	@Override
	public List<Long>  getIndentIdsBySalerIdOrderByProcessAsc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return indentService.getIndentIdsBySalerIdOrderByProcessAsc(salerId, start, limit);


	}



	@Override
	public List<Long>  getIndentIdsBySalerIdOrderByProcessDesc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return indentService.getIndentIdsBySalerIdOrderByProcessDesc(salerId, start, limit);


	}


	 @Override
	public List<Long>  getIndentIdsBySalerIdAndCustomerIdOrderByUpdateAt(Long salerId,Long customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return indentService.getIndentIdsBySalerIdAndCustomerIdOrderByUpdateAt(salerId, customerId, start, limit);
	
	
	}
	
		
	
	
    			
			

	 @Override
	public Integer  countIndentIdsBySalerIdOrderByUpdateAt(Long salerId)throws ServiceException, ServiceDaoException{
		
		return indentService.countIndentIdsBySalerIdOrderByUpdateAt(salerId);
	
	
	}
	
			
			

	 @Override
	public Integer  countIndentIdsBySalerIdAndCustomerIdOrderByUpdateAt(Long salerId,Long customerId)throws ServiceException, ServiceDaoException{
		
		return indentService.countIndentIdsBySalerIdAndCustomerIdOrderByUpdateAt(salerId, customerId);
	
	
	}
	
		
	
		@Override
	public List<Long> getIndentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return indentService.getIndentIds(start, limit);
	}

	@Override
	public Integer countIndentIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return indentService.countIndentIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return indentService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return indentService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   indentService.deleteList(clz, ids);
		
	}
    @Override
	public Long getIndentIdBySalerIdAndCustomerId(Long salerId,Long cid)throws ServiceException, ServiceDaoException{
		 return  indentService.getIndentIdBySalerIdAndCustomerId(salerId,cid);
	}


}

