/**
 * 
 */
package com.ptteng.sca.common.carjn.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.carjn.model.Idocument;
import com.ptteng.common.carjn.service.IdocumentService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class IdocumentSCAClient implements IdocumentService {

    private IdocumentService idocumentService;

	public IdocumentService getIdocumentService() {
		return idocumentService;
	}
	
	
	public void setIdocumentService(IdocumentService idocumentService) {
		this.idocumentService =idocumentService;
	}
	
	
			   
		@Override
		public Long insert(Idocument idocument)throws ServiceException, ServiceDaoException{
		
		return idocumentService.insert(idocument);
		          
		
		}	
		  
    	   
		@Override
		public List<Idocument> insertList(List<Idocument> idocumentList)throws ServiceException, ServiceDaoException{
		
		return idocumentService.insertList(idocumentList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return idocumentService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Idocument idocument)throws ServiceException, ServiceDaoException{
		
		return idocumentService.update(idocument);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Idocument> idocumentList)throws ServiceException, ServiceDaoException{
		
		return idocumentService.updateList(idocumentList);
		          
		
		}	
		  
    	   
		@Override
		public Idocument getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return idocumentService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Idocument> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return idocumentService.getObjectsByIds(ids);
		          
		
		}


	/**
	 *
	 * @param indentId
	 * @param documentName
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIdocumentIdsByIndentIdAndDocumentNameOrderByUpdateAt(Long indentId,String documentName,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return idocumentService.getIdocumentIdsByIndentIdAndDocumentNameOrderByUpdateAt(indentId, documentName, start, limit);
	
	
	}


	/**
	 *
	 * @param indentId
	 * @param personnelType
	 * @param documentType
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt(Long indentId,String personnelType,String documentType,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return idocumentService.getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt(indentId, personnelType, documentType, start, limit);
	
	
	}


	/**
	 *
	 * @param indentId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIdocumentIdsByIndentIdOrderByUpdateAt(Long indentId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return idocumentService.getIdocumentIdsByIndentIdOrderByUpdateAt(indentId, start, limit);
	
	
	}


	/**
	 *
	 * @param cid
	 * @param personnelType
	 * @param documentType
	 * @param certificateName
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIdocumentIdsByAllOrderByUpdateAt(Long cid,String personnelType,String documentType,String certificateName,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return idocumentService.getIdocumentIdsByAllOrderByUpdateAt(cid, personnelType, documentType, certificateName, start, limit);


	}


	/**
	 *
	 * @param indentId
	 * @param documentType
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt(Long indentId,String documentType,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt(indentId, documentType, start, limit);
	
	
	}


	/**
	 *
	 * @param indentId
	 * @param personnelType
	 * @param documentType
	 * @param documentName
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeAndDocumentNameOrderByUpdateAt(Long indentId,String personnelType,String documentType,String documentName,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return idocumentService.getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeAndDocumentNameOrderByUpdateAt(indentId, personnelType, documentType, documentName, start, limit);
	
	
	}

	/**
	 *
	 * @param cid
	 * @param personnelType
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIdsByCidAndPersonnelTypeOrderByUpdateAt(Long cid,String personnelType,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return idocumentService.getIdsByCidAndPersonnelTypeOrderByUpdateAt(cid, personnelType, start, limit);


	}


	/**
	 *
	 * @param indentId
	 * @param documentName
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIdocumentIdsByIndentIdAndDocumentNameOrderByUpdateAt(Long indentId,String documentName)throws ServiceException, ServiceDaoException{
		
		return idocumentService.countIdocumentIdsByIndentIdAndDocumentNameOrderByUpdateAt(indentId, documentName);
	
	
	}


	/**
	 *
	 * @param indentId
	 * @param personnelType
	 * @param documentType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt(Long indentId,String personnelType,String documentType)throws ServiceException, ServiceDaoException{
		
		return idocumentService.countIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt(indentId, personnelType, documentType);
	
	
	}


	/**
	 *
	 * @param indentId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIdocumentIdsByIndentIdOrderByUpdateAt(Long indentId)throws ServiceException, ServiceDaoException{
		
		return idocumentService.countIdocumentIdsByIndentIdOrderByUpdateAt(indentId);
	
	
	}


	/**
	 *
	 * @param indentId
	 * @param documentType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt(Long indentId,String documentType)throws ServiceException, ServiceDaoException{
		
		return idocumentService.countIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt(indentId, documentType);
	
	
	}


	/**
	 *
	 * @param indentId
	 * @param personnelType
	 * @param documentType
	 * @param documentName
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeAndDocumentNameOrderByUpdateAt(Long indentId,String personnelType,String documentType,String documentName)throws ServiceException, ServiceDaoException{
		
		return idocumentService.countIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeAndDocumentNameOrderByUpdateAt(indentId, personnelType, documentType, documentName);
	
	
	}
	
		
	
		@Override
	public List<Long> getIdocumentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return idocumentService.getIdocumentIds(start, limit);
	}
	@Override
	public List<Long> getIdocumentIdsByCustomerId(Long customerId)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return idocumentService.getIdocumentIdsByCustomerId(customerId);
	}
	@Override
	public Integer countIdocumentIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return idocumentService.countIdocumentIds();
	}

	@Override
	public Long getIdByDocumentTypeAndImg(String type,String img) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return idocumentService.getIdByDocumentTypeAndImg(type,img);
	}

	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return idocumentService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return idocumentService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   idocumentService.deleteList(clz, ids);
		
	}


 
}

