/**
 * 
 */
package com.ptteng.sca.common.carjn.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.carjn.model.Guarantee;
import com.ptteng.common.carjn.service.GuaranteeService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class GuaranteeSCAClient implements GuaranteeService {

    private GuaranteeService guaranteeService;

	public GuaranteeService getGuaranteeService() {
		return guaranteeService;
	}
	
	
	public void setGuaranteeService(GuaranteeService guaranteeService) {
		this.guaranteeService =guaranteeService;
	}
	
	
			   
		@Override
		public Long insert(Guarantee guarantee)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.insert(guarantee);
		          
		
		}	
		  
    	   
		@Override
		public List<Guarantee> insertList(List<Guarantee> guaranteeList)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.insertList(guaranteeList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Guarantee guarantee)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.update(guarantee);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Guarantee> guaranteeList)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.updateList(guaranteeList);
		          
		
		}	
		  
    	   
		@Override
		public Guarantee getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Guarantee> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.getObjectsByIds(ids);
		          
		
		}


	/**
	 * @param customerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getGuaranteeIdsByCustomerIdOrderByUpdateAt(Long customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.getGuaranteeIdsByCustomerIdOrderByUpdateAt(customerId,start,limit);
	
	
	}


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getGuaranteeIdByCustomerIdAndPersonnelType(Long customerId,String personnelType)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(customerId,personnelType);
	
	
	}


	/**
	 *
	 * @param customerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countGuaranteeIdsByCustomerIdOrderByUpdateAt(Long customerId)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.countGuaranteeIdsByCustomerIdOrderByUpdateAt(customerId);
	
	
	}


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countGuaranteeIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(Long customerId,String personnelType)throws ServiceException, ServiceDaoException{
		
		return guaranteeService.countGuaranteeIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(customerId,personnelType);
	
	
	}
	
		
	
		@Override
	public List<Long> getGuaranteeIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return guaranteeService.getGuaranteeIds(start, limit);
	}

	@Override
	public Integer countGuaranteeIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return guaranteeService.countGuaranteeIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return guaranteeService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return guaranteeService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   guaranteeService.deleteList(clz, ids);
		
	}


 
}

