/**
 * 
 */
package com.ptteng.sca.common.carjn.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.carjn.model.CustomerSalerRelation;
import com.ptteng.common.carjn.service.CustomerSalerRelationService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class CustomerSalerRelationSCAClient implements CustomerSalerRelationService {

    private CustomerSalerRelationService customerSalerRelationService;

	public CustomerSalerRelationService getCustomerSalerRelationService() {
		return customerSalerRelationService;
	}
	
	
	public void setCustomerSalerRelationService(CustomerSalerRelationService customerSalerRelationService) {
		this.customerSalerRelationService =customerSalerRelationService;
	}
	
	
			   
		@Override
		public Long insert(CustomerSalerRelation customerSalerRelation)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.insert(customerSalerRelation);
		          
		
		}	
		  
    	   
		@Override
		public List<CustomerSalerRelation> insertList(List<CustomerSalerRelation> customerSalerRelationList)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.insertList(customerSalerRelationList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(CustomerSalerRelation customerSalerRelation)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.update(customerSalerRelation);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<CustomerSalerRelation> customerSalerRelationList)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.updateList(customerSalerRelationList);
		          
		
		}	
		  
    	   
		@Override
		public CustomerSalerRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<CustomerSalerRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.getObjectsByIds(ids);
		          
		
		}


	/**
	 *
	 * @param customerId
	 * @param salerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getCustomerSalerRelationIdByCustomerIdAndSalerId(Long customerId,Long salerId)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.getCustomerSalerRelationIdByCustomerIdAndSalerId(customerId,salerId);
	
	
	}


	/**
	 *
	 * @param customerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCustomerSalerRelationIdsByCustomerIdOrderByUpdateAt(Long customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.getCustomerSalerRelationIdsByCustomerIdOrderByUpdateAt(customerId,start,limit);
	
	
	}


	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCustomerSalerRelationIdsBySalerIdOrderByUpdateAt(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.getCustomerSalerRelationIdsBySalerIdOrderByUpdateAt(salerId,start,limit);
	
	
	}


	/**
	 *
	 * @param customerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCustomerSalerRelationIdsByCustomerIdOrderByUpdateAt(Long customerId)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.countCustomerSalerRelationIdsByCustomerIdOrderByUpdateAt(customerId);
	
	
	}


	/**
	 *
	 * @param salerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCustomerSalerRelationIdsBySalerIdOrderByUpdateAt(Long salerId)throws ServiceException, ServiceDaoException{
		
		return customerSalerRelationService.countCustomerSalerRelationIdsBySalerIdOrderByUpdateAt(salerId);
	
	
	}
	
		
	
		@Override
	public List<Long> getCustomerSalerRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerSalerRelationService.getCustomerSalerRelationIds(start, limit);
	}

	@Override
	public Integer countCustomerSalerRelationIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerSalerRelationService.countCustomerSalerRelationIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerSalerRelationService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerSalerRelationService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   customerSalerRelationService.deleteList(clz, ids);
		
	}


 
}

