/**
 * 
 */
package com.ptteng.sca.common.carjn.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.carjn.model.Customer;
import com.ptteng.common.carjn.service.CustomerService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class CustomerSCAClient implements CustomerService {

    private CustomerService customerService;

	public CustomerService getCustomerService() {
		return customerService;
	}
	
	
	public void setCustomerService(CustomerService customerService) {
		this.customerService =customerService;
	}
	
	
			   
		@Override
		public Long insert(Customer customer)throws ServiceException, ServiceDaoException{
		
		return customerService.insert(customer);
		          
		
		}	
		  
    	   
		@Override
		public List<Customer> insertList(List<Customer> customerList)throws ServiceException, ServiceDaoException{
		
		return customerService.insertList(customerList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return customerService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Customer customer)throws ServiceException, ServiceDaoException{
		
		return customerService.update(customer);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Customer> customerList)throws ServiceException, ServiceDaoException{
		
		return customerService.updateList(customerList);
		          
		
		}	
		  
    	   
		@Override
		public Customer getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return customerService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Customer> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return customerService.getObjectsByIds(ids);
		          
		
		}


	/**
	 *
	 * @param number
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getCustomerIdByNumber(String number)throws ServiceException, ServiceDaoException{
		
		return customerService.getCustomerIdByNumber(number);
	
	
	}


	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCustomerIdsBySalerIdOrderByUpdateAt(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return customerService.getCustomerIdsBySalerIdOrderByUpdateAt(salerId, start, limit);
	
	
	}

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getCustomerIdsBySalerIdOrderByUpdateAtAsc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return customerService.getCustomerIdsBySalerIdOrderByUpdateAtAsc(salerId, start, limit);


	}

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getCustomerIdsBySalerIdOrderByProcessAsc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return customerService.getCustomerIdsBySalerIdOrderByProcessAsc(salerId, start, limit);


	}


	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getCustomerIdsBySalerIdOrderByProcessDesc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return customerService.getCustomerIdsBySalerIdOrderByProcessDesc(salerId, start, limit);


	}

	/**
	 *
	 * @param salerId
	 * @param name
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCustomerIdsBySalerIdAndNameOrderByUpdateAt(Long salerId,String name,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return customerService.getCustomerIdsBySalerIdAndNameOrderByUpdateAt(salerId, name, start, limit);
	
	
	}


	/**
	 *
	 * @param salerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCustomerIdsBySalerIdOrderByUpdateAt(Long salerId)throws ServiceException, ServiceDaoException{
		
		return customerService.countCustomerIdsBySalerIdOrderByUpdateAt(salerId);
	
	
	}


	/**
	 *
	 * @param salerId
	 * @param name
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCustomerIdsBySalerIdAndNameOrderByUpdateAt(Long salerId,String name)throws ServiceException, ServiceDaoException{
		
		return customerService.countCustomerIdsBySalerIdAndNameOrderByUpdateAt(salerId, name);
	
	
	}
	
		
	
		@Override
	public List<Long> getCustomerIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerService.getCustomerIds(start, limit);
	}

	@Override
	public Integer countCustomerIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerService.countCustomerIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}

	@Override
	public List<Long> getCustomerIdsByNumberAndSalerId(String number,String salerId, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerService.getCustomerIdsByNumberAndSalerId(number, salerId, start, limit);
	}

	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   customerService.deleteList(clz, ids);
		
	}


 
}

