package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Statistics;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface StatisticsService extends BaseDaoService {

	



   		   
		
		public Long insert(Statistics statistics)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Statistics> insertList(List<Statistics> statisticsList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Statistics statistics)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Statistics> statisticsList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Statistics getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Statistics> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStatisticsIdsBySalerId(Long salerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStatisticsIdsBySalerId(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @param productType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getStatisticsIdBySalerIdAndProductType(Long salerId,String productType)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getStatisticsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countStatisticsIds() throws ServiceException, ServiceDaoException;
	

}

