package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Product;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ProductService extends BaseDaoService {

	



   		   
		
		public Long insert(Product product)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Product> insertList(List<Product> productList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Product product)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Product> productList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Product getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Product> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param type
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countProductIdsByTypeOrderByUpdateAt(String type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param type
	 * @param name
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getProductIdByTypeAndName(String type,String name)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param type
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getProductIdsByTypeOrderByUpdateAt(String type,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param type
	 * @param status
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getProductIdsByTypeAndStatusOrderByUpdateAt(String type,String status,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getProductIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countProductIds() throws ServiceException, ServiceDaoException;
	

}

