package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Permetarial;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface PermetarialService extends BaseDaoService {

	



   		   
		
		public Long insert(Permetarial permetarial)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Permetarial> insertList(List<Permetarial> permetarialList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Permetarial permetarial)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Permetarial> permetarialList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Permetarial getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Permetarial> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param personnelType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countPermetarialIdsByPersonnelTypeOrderByUpdateAt(String personnelType)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param productType
	 * @param personnelType
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getPermetarialIdsByPersonnelTypeOrderByUpdateAt(String productType,String personnelType, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param metarialId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIdsByMetarialIdsOrderByUpdateAt(Long metarialId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param personnelType
	 * @param metarialId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIdsByMetarialIdAndPerTypeOrderByUpdateAt(String personnelType,Long metarialId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPermetarialIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countPermetarialIds() throws ServiceException, ServiceDaoException;
	

}

