package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Material;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface MaterialService extends BaseDaoService {

	



   		   
		
		public Long insert(Material material)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Material> insertList(List<Material> materialList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Material material)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Material> materialList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Material getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Material> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param parentName
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countMaterialIdsByParentNameOrderByUpdateAt(String parentName)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param parentName
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getMaterialIdsByParentNameOrderByUpdateAt(String parentName,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param type
	 * @param status
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getMaterialIdsByTypeAndStatusOrderByUpdateAt(String type,String status,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param metarialName
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getMaterialIdsByMetarialNameOrderByUpdateAt(String metarialName,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getMaterialIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countMaterialIds() throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param metarialName
	 * @param valueName
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public  Long getIdBymetNameAndValueName(Long metarialName,Long valueName) throws   ServiceException, ServiceDaoException;

}

