package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Indent;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface IndentService extends BaseDaoService {

	



   		   
		
		public Long insert(Indent indent)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Indent> insertList(List<Indent> indentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Indent indent)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Indent> indentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Indent getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Indent> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIndentIdsBySalerIdOrderByUpdateAt(Long salerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @param customerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIndentIdsBySalerIdAndCustomerIdOrderByUpdateAt(Long salerId,Long customerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIndentIdsBySalerIdOrderByUpdateAt(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIndentIdsBySalerIdOrderByUpdateAtAsc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIndentIdsBySalerIdOrderByAmount(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIndentIdsBySalerIdOrderByAmountAsc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIndentIdsBySalerIdOrderByProcessAsc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIndentIdsBySalerIdOrderByProcessDesc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @param customerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long getIndentIdBySalerIdAndCustomerId(Long salerId,Long customerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @param customerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIndentIdsBySalerIdAndCustomerIdOrderByUpdateAt(Long salerId,Long customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getIndentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countIndentIds() throws ServiceException, ServiceDaoException;
	

}

