package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.IdocumentTemp;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface IdocumentTempService extends BaseDaoService {

	



   		   
		
		public Long insert(IdocumentTemp idocumentTemp)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<IdocumentTemp> insertList(List<IdocumentTemp> idocumentTempList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(IdocumentTemp idocumentTemp)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<IdocumentTemp> idocumentTempList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public IdocumentTemp getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<IdocumentTemp> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param documentType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIdocumentTempIdsByCustomerIdAndDocumentTypeOrderByUpdateAt(Long customerId, String documentType)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @param documentType
	 * @param documentName
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIdocumentTempIdsByCustomerIdAndPersonnelTypeAndDocumentTypeAndDocumentNameOrderByUpdateAt(Long customerId, String personnelType, String documentType, String documentName)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param documentName
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIdocumentTempIdsByCustomerIdAndDocumentNameOrderByUpdateAt(Long customerId, String documentName)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @param documentType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIdocumentTempIdsByCustomerIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt(Long customerId, String personnelType, String documentType)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param customerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIdocumentTempIdsByCustomerIdOrderByUpdateAt(Long customerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param documentType
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIdocumentTempIdsByCustomerIdAndDocumentTypeOrderByUpdateAt(Long customerId, String documentType, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @param documentType
	 * @param documentName
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIdocumentTempIdsByCustomerIdAndPersonnelTypeAndDocumentTypeAndDocumentNameOrderByUpdateAt(Long customerId, String personnelType, String documentType, String documentName, Integer start, Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param customerId
	 * @param documentName
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIdocumentTempIdsByCustomerIdAndDocumentNameOrderByUpdateAt(Long customerId, String documentName, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @param documentType
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIdocumentTempIdsByCustomerIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt(Long customerId, String personnelType, String documentType, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIdocumentTempIdsByCustomerIdOrderByUpdateAt(Long customerId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getIdocumentTempIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countIdocumentTempIds() throws ServiceException, ServiceDaoException;



}

