package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Guarantee;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface GuaranteeService extends BaseDaoService {

	



   		   
		
		public Long insert(Guarantee guarantee)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Guarantee> insertList(List<Guarantee> guaranteeList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Guarantee guarantee)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Guarantee> guaranteeList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Guarantee getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Guarantee> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGuaranteeIdsByCustomerIdOrderByUpdateAt(Long customerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGuaranteeIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(Long customerId,String personnelType)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getGuaranteeIdsByCustomerIdOrderByUpdateAt(Long customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public  Long  getGuaranteeIdByCustomerIdAndPersonnelType(Long customerId,String personnelType)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getGuaranteeIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countGuaranteeIds() throws ServiceException, ServiceDaoException;
	

}

