package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.CustomerMaterialRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface CustomerMaterialRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(CustomerMaterialRelation customerMaterialRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<CustomerMaterialRelation> insertList(List<CustomerMaterialRelation> customerMaterialRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(CustomerMaterialRelation customerMaterialRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<CustomerMaterialRelation> customerMaterialRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public CustomerMaterialRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<CustomerMaterialRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(String customerId,String personnelType)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCustomerMaterialRelationIdsByCustomerIdOrderByUpdateAt(String customerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(String customerId,String personnelType,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @param constantName
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getIdsByCidAndPersonnelTypeAndConstantname(String customerId,String personnelType,String constantName)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getCustomerMaterialRelationIdByCustomerIdAndPersonnelType(String customerId,String personnelType)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerMaterialRelationIdsByCustomerIdOrderByUpdateAt(String customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getCustomerMaterialRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countCustomerMaterialRelationIds() throws ServiceException, ServiceDaoException;
	

}

