package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Constant;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ConstantService extends BaseDaoService {

	



   		   
		
		public Long insert(Constant constant)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Constant> insertList(List<Constant> constantList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Constant constant)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Constant> constantList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Constant getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Constant> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param type
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countConstantIdsByTypeOrderByUpdateAt(String type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param type
	 * @param value
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getConstantIdByTypeAndValue(String type,String value)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param name
	 * @param type
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getConstantIdByNameAndType (String name,String type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param type
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getConstantIdsByTypeOrderByUpdateAt(String type,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param parentType
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getConstantsIdsByParentTypeOrderByUpdateAt(String parentType,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getConstantIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return int
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countConstantIds() throws ServiceException, ServiceDaoException;
	

}

