package com.ptteng.common.carjn.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "product")
public class Product implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2099302356507006976L;	
	
	public static final String new_productType = "0";
	public static final String old_productType="1";
	public static final String loan_productType = "2";
	public static final String PARENT_TYPE_A = "a";
	public static final String PARENT_TYPE_B = "b";

	public static final String UNPUBLISHED = "1";
	public static final String PUBLISHED = "2";


	public static final String ADDRESS = "address";
	public static final String LOAN = "loan";

   //是否需要小于24岁的添加直系担保人选项：1--不需要；2–需要
	public static final Integer NEED = 2;
	public static final Integer UN_NEED = 1;





	private  Long id;
	
  	 
    private  String type;

	private String aliases;
  	 
    private  String name;
	
  	 
    private  Long channel;
	
  	 
    private  String interestRate;
	
  	 
    private  String firstUpperPercent;


	private  String firstLowerPercent;

    private  String loanLowerLimit;
	
  	 
    private  String loanUpperLimit;
	
  	 
    private  String visit;
	
  	 
    private  String periodOperator;
	private  String periodLimitFlag;
	private  String periodLimit;




	private  String drivingKilomet;
	private String drivingOperator;
	
  	 
    private  String recommendFlag;
	private  String gpsFirstAmount  ;//;
	private  String gpsSenAmount ;//;
	private  String gpsThirAmount ;//;
	private  String gpsFurAmount ;//;
	private  String gpsFivAmount ;//;

	private String spouseFlag;
	private String spouseLimit;
	private String status;


	private Long roleCount;
	private String region;
	private String description;

	private Integer minorGuarantee;
	private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;
	private  Long publishAt;




	@Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "type")
	public String getType() {
		return type;
	}
	
	
	public void setType(String type) {
		this.type = type;
	}
		 	@Column(name = "name")
	public String getName() {
		return name;
	}
	
	
	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "aliases")
	public String getAliases() {
		return aliases;
	}

	public void setAliases(String aliases) {
		this.aliases = aliases;
	}

	@Column(name = "channel")
	public Long getChannel() {
		return channel;
	}

	public void setChannel(Long channel) {
		this.channel = channel;
	}

		 	@Column(name = "interest_rate")
	public String getInterestRate() {
		return interestRate;
	}
	
	
	public void setInterestRate(String interestRate) {
		this.interestRate = interestRate;
	}

	@Column(name = "period_operator")
	public String getPeriodOperator() {
		return periodOperator;
	}

	public void setPeriodOperator(String periodOperator) {
		this.periodOperator = periodOperator;
	}
	@Column(name = "driving_operator")
	public String getDrivingOperator() {
		return drivingOperator;
	}

	public void setDrivingOperator(String drivingOperator) {
		this.drivingOperator = drivingOperator;
	}

	@Column(name = "loan_lower_limit")
	public String getLoanLowerLimit() {
		return loanLowerLimit;
	}
	
	
	public void setLoanLowerLimit(String loanLowerLimit) {
		this.loanLowerLimit = loanLowerLimit;
	}
		 	@Column(name = "loan_upper_limit")
	public String getLoanUpperLimit() {
		return loanUpperLimit;
	}
	
	
	public void setLoanUpperLimit(String loanUpperLimit) {
		this.loanUpperLimit = loanUpperLimit;
	}
		 	@Column(name = "visit")
	public String getVisit() {
		return visit;
	}
	
	
	public void setVisit(String visit) {
		this.visit = visit;
	}
		 	@Column(name = "period_limit")
	public String getPeriodLimit() {
		return periodLimit;
	}
	
	
	public void setPeriodLimit(String periodLimit) {
		this.periodLimit = periodLimit;
	}
		 	@Column(name = "driving_kilometers")
	public String getDrivingKilomet() {
		return drivingKilomet;
	}
	
	
	public void setDrivingKilomet(String drivingKilomet) {
		this.drivingKilomet = drivingKilomet;
	}
		 	@Column(name = "recommend_flag")
	public String getRecommendFlag() {
		return recommendFlag;
	}
	
	
	public void setRecommendFlag(String recommendFlag) {
		this.recommendFlag = recommendFlag;
	}

	@Column(name = "gps_1st_amount")
	public String getGpsFirstAmount() {
		return gpsFirstAmount;
	}

	public void setGpsFirstAmount(String gpsFirstAmount) {
		this.gpsFirstAmount = gpsFirstAmount;
	}
	@Column(name = "gps_5th_amount")
	public String getGpsFivAmount() {
		return gpsFivAmount;
	}

	public void setGpsFivAmount(String gpsFivAmount) {
		this.gpsFivAmount = gpsFivAmount;
	}
	@Column(name = "gps_4th_amount")
	public String getGpsFurAmount() {
		return gpsFurAmount;
	}

	public void setGpsFurAmount(String gpsFurAmount) {
		this.gpsFurAmount = gpsFurAmount;
	}
	@Column(name = "gps_3rd_amount")
	public String getGpsThirAmount() {
		return gpsThirAmount;
	}

	public void setGpsThirAmount(String gpsThirAmount) {
		this.gpsThirAmount = gpsThirAmount;
	}
	@Column(name = "gps_2nd_amount")
	public String getGpsSenAmount() {
		return gpsSenAmount;
	}

	public void setGpsSenAmount(String gpsSenAmount) {
		this.gpsSenAmount = gpsSenAmount;
	}

	@Column(name = "first_upper_percent")
	public String getFirstUpperPercent() {
		return firstUpperPercent;
	}

	public void setFirstUpperPercent(String firstUpperPercent) {
		this.firstUpperPercent = firstUpperPercent;
	}
	@Column(name = "first_lower_percent")
	public String getFirstLowerPercent() {
		return firstLowerPercent;
	}

	public void setFirstLowerPercent(String firstLowerPercent) {
		this.firstLowerPercent = firstLowerPercent;
	}
	@Column(name = "period_limit_flag")
	public String getPeriodLimitFlag() {
		return periodLimitFlag;
	}

	public void setPeriodLimitFlag(String periodLimitFlag) {
		this.periodLimitFlag = periodLimitFlag;
	}

	@Column(name = "spouse_flag")
	public String getSpouseFlag() {
		return spouseFlag;
	}

	public void setSpouseFlag(String spouseFlag) {
		this.spouseFlag = spouseFlag;
	}
	@Column(name = "spouse_limit")
	public String getSpouseLimit() {
		return spouseLimit;
	}

	public void setSpouseLimit(String spouseLimit) {
		this.spouseLimit = spouseLimit;
	}

	@Column(name = "status")
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@Column(name = "role_count")
	public Long getRoleCount() {
		return roleCount;
	}

	public void setRoleCount(Long roleCount) {
		this.roleCount = roleCount;
	}

	@Column(name = "region")
	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	@Column(name = "description")
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}





	@Column(name = "publish_at")
	public Long getPublishAt() {
		return publishAt;
	}

	public void setPublishAt(Long publishAt) {
		this.publishAt = publishAt;
	}
	@Column(name = "minor_guarantee")
	public Integer getMinorGuarantee() {
		return minorGuarantee;
	}

	public void setMinorGuarantee(Integer minorGuarantee) {
		this.minorGuarantee = minorGuarantee;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

