package com.ptteng.common.carjn.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "customer_material_relation")
public class CustomerMaterialRelation implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 8917551148568850432L;
    @JsonIgnore
    private Long id;

    @JsonIgnore
    private Long customerId;

    @JsonIgnore
    private String personnelType;

    @JsonIgnore
    private String constantName;

    @JsonIgnore
    private String materialName;

    @JsonIgnore
    private Long createBy;

    @JsonIgnore
    private Long updateBy;

    @JsonIgnore
    private Long updateAt;

    @JsonIgnore
    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "customer_id")
    public Long getCustomerId() {
        return customerId;
    }


    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @Column(name = "personnel_type")
    public String getPersonnelType() {
        return personnelType;
    }


    public void setPersonnelType(String personnelType) {
        this.personnelType = personnelType;
    }

    @Column(name = "constant_name")
    public String getConstantName() {
        return constantName;
    }


    public void setConstantName(String constantName) {
        this.constantName = constantName;
    }

    @Column(name = "material_name")
    public String getMaterialName() {
        return materialName;
    }


    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

