package com.ptteng.academy.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "notice")
public class Notice implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1473303179123324928L;

    public static final Integer NOTICE_UP = 1;
    public static final Integer NOTICE_DOWN = 2;


    private Long id;

    private String title;


    private String context;

    private String contextIOS;


    private Integer status;

    /**
     * 年级部
     */
    private Integer gradeDepartment;

    /**
     * iOS公告栏标题
     */
    private String iosTitle;

    /**
     * 组
     */
    private Long groupId;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }


    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "context")
    public String getContext() {
        return context;
    }


    public void setContext(String context) {
        this.context = context;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "context_ios")
    public String getContextIOS() {
        return contextIOS;
    }

    public void setContextIOS(String contextIOS) {
        this.contextIOS = contextIOS;
    }

    @Column(name = "grade_department")
    public Integer getGradeDepartment() {
        return gradeDepartment;
    }

    @Column(name = "ios_title")
    public String getIosTitle() {
        return iosTitle;
    }

    @Column(name = "group_id")
    public Long getGroupId() {
        return groupId;
    }

    public void setGradeDepartment(Integer gradeDepartment) {
        this.gradeDepartment = gradeDepartment;
    }

    public void setIosTitle(String iosTitle) {
        this.iosTitle = iosTitle;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }
}

