package com.ptteng.sca.academy.user.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.user.model.CooperatorOrder;
import com.ptteng.academy.user.model.CooperatorUserStatistics;
import com.ptteng.academy.user.service.CooperatorStatisticsService;

import java.util.List;
import java.util.Map;

public class CooperatorStatisticsSCAClient implements CooperatorStatisticsService{

    private CooperatorStatisticsService cooperatorStatisticsService;

    public CooperatorStatisticsService getCooperatorStatisticsService() {
        return cooperatorStatisticsService;
    }

    public void setCooperatorStatisticsService(CooperatorStatisticsService cooperatorStatisticsService) {
        this.cooperatorStatisticsService = cooperatorStatisticsService;
    }


    @Override
    public List<CooperatorUserStatistics> getCooperatorUserStatisticsByDynamicCondition(Map<String,Object> condition,Integer start,Integer size) {
        return cooperatorStatisticsService.getCooperatorUserStatisticsByDynamicCondition(condition,start,size);
    }

    @Override
    public List<CooperatorOrder> getCooperatorOrdersByDynamicCondition(Map<String, Object> condition, Integer start, Integer size) {
        return cooperatorStatisticsService.getCooperatorOrdersByDynamicCondition(condition, start, size);
    }

    @Override
    public Integer getLessonOrderNumber(Long cooperatorLinkTime,Long startAt,Long endAt) {
        return cooperatorStatisticsService.getLessonOrderNumber( cooperatorLinkTime,startAt,endAt);
    }

    @Override
    public Integer getLessonOrderNumberOfTengXunZhiHuiXiaoYuan(Long cooperatorLinkTime, Long startAt, Long endAt) {
        return cooperatorStatisticsService.getLessonOrderNumberOfTengXunZhiHuiXiaoYuan( cooperatorLinkTime,startAt,endAt);
    }

    @Override
    public Double getLessonOrderMoney(Long cooperatorLinkTime,Long startAt,Long endAt) {
        return cooperatorStatisticsService.getLessonOrderMoney( cooperatorLinkTime,startAt,endAt);
    }

    @Override
    public Double getLessonOrderMoneyOfTengXunZhiHuiXiaoYuan(Long cooperatorLinkTime, Long startAt, Long endAt) {
        return cooperatorStatisticsService.getLessonOrderMoneyOfTengXunZhiHuiXiaoYuan( cooperatorLinkTime,startAt,endAt);
    }

    @Override
    public Integer getMemberOrderNumber(Long cooperatorLinkTime,Long startAt,Long endAt) {
        return cooperatorStatisticsService.getMemberOrderNumber( cooperatorLinkTime,startAt,endAt);
    }

    @Override
    public Integer getMemberOrderNumberOfTengXunZhiHuiXiaoYuan(Long cooperatorLinkTime, Long startAt, Long endAt) {
        return cooperatorStatisticsService.getMemberOrderNumberOfTengXunZhiHuiXiaoYuan( cooperatorLinkTime,startAt,endAt);
    }

    @Override
    public Double getMemberOrderMoney(Long cooperatorLinkTime,Long startAt,Long endAt) {
        return cooperatorStatisticsService.getMemberOrderMoney( cooperatorLinkTime,startAt,endAt);
    }

    @Override
    public Double getMemberOrderMoneyOfTengXunZhiHuiXiaoYuan(Long cooperatorLinkTime, Long startAt, Long endAt) {
        return cooperatorStatisticsService.getMemberOrderMoneyOfTengXunZhiHuiXiaoYuan( cooperatorLinkTime,startAt,endAt);
    }

    @Override
    public List<CooperatorOrder> getMemberDateCooperatorOrder(Long dateStart, Long dateEnd,Long cooperatorLinkTime) {
        return cooperatorStatisticsService.getMemberDateCooperatorOrder(dateStart,dateEnd,cooperatorLinkTime);
    }

    @Override
    public List<CooperatorOrder> getLessonDateCooperatorOrder(Long dateStart, Long dateEnd,Long cooperatorLinkTime) {
        return cooperatorStatisticsService.getLessonDateCooperatorOrder(dateStart, dateEnd,cooperatorLinkTime);
    }

    @Override
    public List<CooperatorOrder> getDateCooperatorOrder(Long dateStart, Long dateEnd, Integer page, Integer size) {
        return cooperatorStatisticsService.getDateCooperatorOrder(dateStart, dateEnd, page, size);
    }

    @Override
    public List<CooperatorOrder> getDateCooperatorOrderOfTengXunZhiHuiXiaoYuan(Long dateStart, Long dateEnd, Integer start, Integer size) {
        return cooperatorStatisticsService.getDateCooperatorOrderOfTengXunZhiHuiXiaoYuan(dateStart, dateEnd, start, size);
    }

    @Override
    public Integer countDateCooperatorOrder(Long dateStart, Long dateEnd) {
        return cooperatorStatisticsService.countDateCooperatorOrder(dateStart, dateEnd);
    }

    @Override
    public Integer countDateCooperatorOrderOfTengXunZhiHuiXiaoYuan(Long dateStart, Long dateEnd) {
        return cooperatorStatisticsService.countDateCooperatorOrderOfTengXunZhiHuiXiaoYuan(dateStart, dateEnd);
    }
}
