package com.ptteng.academy.user.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.user.model.UserRecommend;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserRecommendService extends BaseDaoService {


    public Long insert(UserRecommend userRecommend) throws ServiceException, ServiceDaoException;


    public List<UserRecommend> insertList(List<UserRecommend> userRecommendList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(UserRecommend userRecommend) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<UserRecommend> userRecommendList) throws ServiceException, ServiceDaoException;


    public UserRecommend getObjectById(Long id) throws ServiceException, ServiceDaoException;

    public UserRecommend getUserRecommendByUserId(Long userId) throws ServiceException, ServiceDaoException;


    public List<UserRecommend> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserRecommendIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserRecommendIds() throws ServiceException, ServiceDaoException;


}

